//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Connectivity.hpp,v 1.3 2004/01/24 13:33:39 delpinux Exp $

#ifndef CONNECTIVITY_HPP
#define CONNECTIVITY_HPP

/**
 * @file   Connectivity.hpp
 * @author Stephane Del Pino
 * @date   Thu Jan 16 18:32:19 2003
 * 
 * @brief  face connectivity of elements
 * 
 * 
 */

#include <Vector.hpp>
#include <TinyVector.hpp>

template<typename CellType>
class Connectivity
{
public:
  typedef TinyVector<CellType::NumberOfNeighbours, const CellType*> Type;

private:
  Vector<typename Connectivity<CellType>::Type> __connections;

public:

  const typename Connectivity<CellType>::Type& operator()(const size_t i) const
  {
    return __connections[i];
  }

  typename Connectivity<CellType>::Type& operator()(const size_t i)
  {
    return __connections[i];
  }

  Connectivity(const size_t numberOfCells)
    : __connections(numberOfCells)
  {
    ;
  }

  Connectivity(const Connectivity& c)
    : __connections(c)
  {
    ;
  }

  ~Connectivity()
  {
    ;
  }
};

#endif // CONNECTIVITY_HPP
