//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: MeshTetrahedrizor.cpp,v 1.4 2004/04/15 15:21:08 delpinux Exp $

#include <MeshTetrahedrizor.hpp>

#include <MeshOfTetrahedra.hpp>
#include <Structured3DMesh.hpp>


template <>
void MeshTetrahedrizor::
__build<Structured3DMesh>()
{
  // In this function hexahedra are divide into 5 tetrahedra
  Structured3DMesh& M
    = static_cast<Structured3DMesh&>(*__input);

  ReferenceCounting<Vector<Tetrahedron> > __tetrahedra
    = new Vector<Tetrahedron>(5*M.numberOfCells());

  Vector<Tetrahedron>& tetrahedra = *__tetrahedra;

  size_t cellNumber=0;
  for(size_t i=0; i<M.shape().nx()-1; ++i)
    for(size_t j=0; j<M.shape().ny()-1; ++j)
      for(size_t k=0; k<M.shape().nz()-1; ++k) {
	CartesianHexahedron& H = M.cell(i,j,k);

	if ( (i+j+k) % 2 == 0) {
	  Tetrahedron T0(H(4), H(0), H(7), H(5));
	  Tetrahedron T1(H(1), H(2), H(0), H(5));
	  Tetrahedron T2(H(0), H(2), H(7), H(5));
	  Tetrahedron T3(H(6), H(2), H(5), H(7));
	  Tetrahedron T4(H(3), H(0), H(2), H(7));

	  tetrahedra[5*cellNumber  ] = T0;
	  tetrahedra[5*cellNumber+1] = T1;
	  tetrahedra[5*cellNumber+2] = T2;
	  tetrahedra[5*cellNumber+3] = T3;
	  tetrahedra[5*cellNumber+4] = T4;
	} else {
	  Tetrahedron T0(H(0), H(1), H(3), H(4));
	  Tetrahedron T1(H(5), H(1), H(4), H(6));
	  Tetrahedron T2(H(1), H(4), H(6), H(3));
	  Tetrahedron T3(H(2), H(1), H(6), H(3));
	  Tetrahedron T4(H(7), H(3), H(6), H(4));
      
	  tetrahedra[5*cellNumber  ] = T0;
	  tetrahedra[5*cellNumber+1] = T1;
	  tetrahedra[5*cellNumber+2] = T2;
	  tetrahedra[5*cellNumber+3] = T3;
	  tetrahedra[5*cellNumber+4] = T4;
	}
	cellNumber++;
      }

//   std::vector<ReferenceCounting<SurfaceMeshOfTriangles> > faces;

//   faces.resize(M.numberOfSurfaceMeshes());

//   for (size_t i =0; i<M.numberOfSurfaceMeshes(); ++i) {
//     const SurfaceMeshOfQuadrangles& sq = M.surfaceMeshOfQuadrangles(i);
//     faces[i] = new SurfaceMeshOfTriangles(2 * sq.numberOfCells());
//     size_t quadrangleNumber = 0;
//     for (SurfaceMeshOfQuadrangles::const_iterator j=(sq);
// 	 not(j.end()); ++j) {

//       const Quadrangle& Q = *j;
//       Triangle T1(Q(0), Q(1), Q(2), Q.reference());
//       Triangle T2(Q(2), Q(3), Q(0), Q.reference());

//       (*faces[i]).cell(quadrangleNumber*2)     = T1;
//       (*faces[i]).cell(quadrangleNumber*2 + 1) = T2;
//       quadrangleNumber++;
//     }
//   }

  MeshOfTetrahedra* meshOfTetrahedra
    = new MeshOfTetrahedra(M.verticesSet(),
			   __tetrahedra);

  __mesh = meshOfTetrahedra;
  std::cerr << __FILE__ << ':' << __LINE__ << ": WARNING implemention incomplete\n";
}


void
MeshTetrahedrizor::run()
{
  switch ((*__input).type()) {
  case Mesh::cartesianHexahedraMesh: {
    __build<Structured3DMesh>();
    break;
  }
  default: {
    fferr(0) << __FILE__ << ':' << __LINE__ << ": Not implemented\n";
    std::exit(1);
  }
  }
}
