//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDESolution.hpp,v 1.1.1.1 2003/02/17 16:32:51 delpinux Exp $

#ifndef PDESOLUTION_H
#define PDESOLUTION_H

#include <Solution.hpp>
#include <BaseVector.hpp>

#include <ReferenceCounting.hpp>

#include <DegreeOfFreedomSet.hpp>

#include <vector>

class FEMUserFunction;
class PDESolution 
  : public Solution
{
private:
  const DegreeOfFreedomSet& __degreeOfFreedomSet;

  BaseVector* pValue;

  //! Not copy constructor ?
  PDESolution(const PDESolution& pdeSolution)
    : __degreeOfFreedomSet(pdeSolution.__degreeOfFreedomSet)
  {
    ;
  }

public:

  void setUserFunction (const std::vector<ReferenceCounting<FEMUserFunction> >& U);

  void getUserFunction (std::vector<ReferenceCounting<FEMUserFunction> >& U) const;

  BaseVector& values()
  {
    return *pValue;
  }

  const BaseVector& values() const
  {
    return *pValue;
  }

  inline const size_t size() const
  {
    return __degreeOfFreedomSet.size();
  }

  PDESolution(const DegreeOfFreedomSet& d);

  ~PDESolution()
  {
    delete pValue;
  }
};

#endif

