//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: LabeledEnum.hpp,v 1.2 2003/05/05 19:06:39 delpinux Exp $

#ifndef _LABELED_ENUM_HPP_
#define _LABELED_ENUM_HPP_

#include <StringEquality.hpp>
#include <IdentifierSet.hpp>

template <typename __EnumType>
class LabeledEnum
{
public:
  typedef __EnumType EnumType;

private:

  typedef std::map<__EnumType,
		   const char*,
		   std::less<__EnumType> > EnumSet;

  typedef std::map<const char*,
		   __EnumType,
		   StringEquality> LabelSet;

  EnumSet  __enumSet;
  LabelSet __labelSet;

public:
  void get(IdentifierSet& I)
  {
    for (typename LabelSet::iterator i = __labelSet.begin();
	 i != __labelSet.end(); ++i) {
      I.insert((*i).first);
    }
  }

  void add(const char* c, const EnumType t)
  {
    typename LabelSet::iterator name = __labelSet.find(c);
    typename EnumSet::iterator value = __enumSet.find(t);

    if (name != __labelSet.end()) {
      fferr(0) << "the label \'" << c << "\' has already been associated to \'"
	       << t << "\'\n";
      fferr(0) << "found: " <<(*name).first << '\n';
      fferr(0) << "list:\n";
      for (typename LabelSet::iterator i = __labelSet.begin();
	   i != __labelSet.end(); ++i) {
	fferr(0) << '\t' <<(*i).first << '\n';
      }
      std::exit(1);
    } else if (value != __enumSet.end()) {
      fferr(0) << "the enum \'" << t << "\' has already been associated to \'"
	       << (*value).second << "\'\n";
      std::exit(1);
    } else {
      __labelSet[c] = t;
      __enumSet [t] = c;
    }
  }

  const __EnumType operator()(const char* c) const
  {
    typename LabelSet::const_iterator i = __labelSet.find(c);
    if (i != __labelSet.end()) {
      return (*i).second;
    } else {
      fferr(2) << "\n\"" << c << "\" is not associated to any enum\n";
      fferr(2) << "Possible cases are:\n";
      fferr(2) << *this << '\n';
      std::exit(1);
      return (*i).second;
    } 
  }

  friend std::ostream& operator << (std::ostream& os,
				    const LabeledEnum<__EnumType>& l)
  {
    for (typename LabeledEnum<__EnumType>::LabelSet::const_iterator i
	   = l.__labelSet.begin();
 	 i != l.__labelSet.end(); ++i) {
      os << (*i).second << '\t' << (*i).first << '\n';
    }
    return os;
  }

  LabeledEnum()
  {
    ;
  }

  ~LabeledEnum()
  {
    ;
  }
};

#endif // _LABELED_ENUM_HPP_

