use strict;

my $binsize = 8192 - 32; # 4096;
my $maxfrag = 1.2;
my $exactuntil = 64;
my $minsize = 8;
my $alignment = 8;

my $prev = $alignment;

my $count = 0;
my %bin;

for (my $i = $minsize; $i <= $binsize; $i += $alignment) {
    if ($i <= $exactuntil) {
	# Exact size classes up to here.
	$bin{$count++} = $i;
	$prev = $i;
    } else {
	# Now check max internal fragmentation.
	my $c = int ($binsize / $i);
	my $pagefrag = ($binsize / ($c * $i));
	if ($pagefrag <= $maxfrag) {
	    my $frag = ($i + $alignment) / $prev;
	    if ($frag > $maxfrag) {
		if (($c > 1) || (($binsize / $i) <= $maxfrag)) {
		    $bin{$count++} = $i;
		    $prev = $i;
		}
	    }
	}
    }
}

print "enum { NUM_BINS = $count };\n";

print "const size_t _bins[] = {";

for (my $i = 0; $i < $count - 1; $i++) {
    print $bin{$i}, ", ";
}

print $bin{$count-1}, "};\n";

my $cnt = ($binsize - $alignment - $minsize) / $alignment;

print "const size_t _sizeClasses[$cnt] = {";

my $n = 0;

my $j = $bin{$n};
for (my $i = $minsize; $i < $binsize; $i += $alignment) {
    if ($i > $j) {
	$n++;
	$j = $bin{$n};
    }
    print $n;
    if ($i + $alignment >= $binsize) {
	print " ";
    } else {
	print ", ";
    }
}

print "};\n";


