#!/usr/bin/env python2.3

# This script assumes highlight was installed in default directories.
# To build the extension, run "python2.3 setup.py build"
# Copy this file to the lib.linux-xxx directory, and invoke it there
##
# To install the extension, run "python2.3 setup.py install"
# The module may be imported from every python script as expected.
#
# Docuemntation will be improved in final release...

import highlight
import os

OUT_DIR    = os.environ['HOME'] +'/'
IN_FILE    = __file__;
OUT_FILE   = OUT_DIR + "highlight_pymod_example.html"
CSS_REF = 'format.css'
CSS_OUTFILE= OUT_DIR + CSS_REF

INSTALLATION_DIR='/usr/share/highlight/'
LANGUAGE_DEFINITION=INSTALLATION_DIR + 'langDefs/py.lang'
COLOURTHEME_DEFINITION=INSTALLATION_DIR + 'themes/kwrite.style'
#INDENT_SCHEME=INSTALLATION_DIR + 'indentSchemes/kr.indent'

print "Highlight version: ", highlight.VERSION

# get a Codegenerator object
generator=highlight.CodeGenerator(outputformat=highlight.HTML,      # values: HTML, XHTML, TEX,  LATEX, XSL, RTF  
                                  stylepath=COLOURTHEME_DEFINITION,    # path to colour theme definition

# Optional parameters:
                                 cssoutfile=CSS_REF    # path to external css file (only HTML, XHTML)  
#                                 includecss=1,        # bool; default: 0 (only HTML, XHTML) 
#                                 attachanchors=1,     # bool; default: 0 (only HTML, XHTML) 
#                                 fopcompatible=1,     # bool; default: 0 (only XSL) 
#                                 replacequotes=1      # bool; default: 0 (only LATEX)     
#                                 linenumbers=1,       # bool, default:0
#                                 fillzeroes=1,        # bool, default:0
#                                 fragment=1,          # bool, default:0
#                                 numberspaces=4,      # values: 0..8; default: 2
#                                 wrappingstyle=2,     # values: highlight.WRAP_DISABLED, highlight.WRAP_SIMPLE,  
#                                                      #         highlight.WRAP_DEFAULT 
#                                                      #         default: highlight.WRAP_DISABLED
                                )

# get output format of Generator instance
#generator.getOutputFormat()
			    
# set language definition
generator.initLanguage(LANGUAGE_DEFINITION)		

# set indentation scheme
# generator.initIndentationScheme(INDENT_SCHEME)

print "Writing %s..." % OUT_FILE

# Generate output 
generator.printOutput(infile=IN_FILE, outfile=OUT_FILE)	    

# Generate external CSS file
generator.printExternalStyle("", CSS_OUTFILE)

# Print all members of the highlight module
print dir (highlight)

