#ifndef __errorh__
#define __errorh__

#include <string>

using namespace std;

class HTML;

enum ErrNum{e_CloseNoDef,e_CloseNoIf,e_ElseNoClose,e_ElseNoIf,e_DefNoClose,
  e_IfNoClose,e_BadCompare,e_BadScope,e_BadVarName,e_BadProcName,e_BadFormat,
  e_BadFormat2,e_NoName,e_NoSrc,e_NoEntry,e_NoValue,e_NoDataSrc,e_UndefVar,
  e_UndefProc,e_UndefEntry,e_UndefPregroup,e_UndefPostgroup,e_UndefStringProc,
  e_FileNotOpen,e_TooDeep,e_RunOnVar,e_MissingColon,e_ExpectBrackets,
  e_ExpectCloseBracket,e_UntermQuotes,e_DataBadFormat,e_NavBadFormat,
  e_ParamWrong,e_ParamNone,e_ParamOne,e_ElseIfNoIf,e_ElseIfNoClose,
  e_CloseNoComment,e_CommentNoClose,e_NoFrom,e_NoTo,e_StepIsZero,
  e_EndedInQuotes,e_EndedInSingles,e_EndedInElement};

extern void Warn(const HTML& cur,const string& mess);
extern void Warn(const string& mess);
extern void Warn(ErrNum mess);
extern void Error(const HTML& cur,const string& mess);
extern void Error(const HTML& cur,ErrNum mess);
extern void Error(const HTML& cur,ErrNum mess,const string& data);
extern void Error(const HTML& cur,const string& data,ErrNum mess);
extern void Error(const string& mess);
extern void Error(ErrNum mess);
extern void Debug(const HTML& cur,const string& mess);
#endif
