#ifndef __pluginh__
  #include "../plugin.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif
#ifndef __polytypeh__
  #include "../polytype.h"
#endif

#include <string>
#include <vector>
#include <cstdio>

class dsoEnglishMod :public Plugin{
public:
  dsoEnglishMod();
  virtual void Init();
private:
  static void DAYNAME(__HITOPFUNC__);
  static void MONTHNAME(__HITOPFUNC__);
  static void DAYSHORTNAME(__HITOPFUNC__);
  static void MONTHSHORTNAME(__HITOPFUNC__);
  static void DAYABBREV(__HITOPFUNC__);
  static void MONTHABBREV(__HITOPFUNC__);
  static void ORDINAL(__HITOPFUNC__);
};

static dsoEnglishMod initmodule;

static const string daynames[]={"Sunday","Monday","Tuesday","Wednesday",
  "Thursday","Friday","Saturday"};
static const string monthnames[]={"January","February","March","April","May",
  "June","July","August","September","October","November","December"};
static const string dayshortnames[]={"Sun","Mon","Tue","Wed","Thu","Fri",
  "Sat"};
static const string monthshortnames[]={"Jan","Feb","Mar","Apr","May","Jun",
  "Jul","Aug","Sep","Oct","Nov","Dec"};
static const string dayabbrevs[]={"Su","M","Tu","W","Th","F","Sa"};
static const string monthabbrevs[]={"Jan","Feb","Mar","Apr","May","Jun",
  "Jul","Aug","Sep","Oct","Nov","Dec"};

dsoEnglishMod::dsoEnglishMod() {
  RegisterPlugin(string("english"),1);
}

void dsoEnglishMod::Init(){
  SetNamespace("ENGLISH");
  RegisterFunction("DAYNAME",&dsoEnglishMod::DAYNAME);
  RegisterFunction("MONTHNAME",&dsoEnglishMod::MONTHNAME);
  RegisterFunction("DAYSHORTNAME",&dsoEnglishMod::DAYSHORTNAME);
  RegisterFunction("MONTHSHORTNAME",&dsoEnglishMod::MONTHSHORTNAME);
  RegisterFunction("DAYABBREV",&dsoEnglishMod::DAYABBREV);
  RegisterFunction("MONTHABBREV",&dsoEnglishMod::MONTHABBREV);
  RegisterFunction("ORDINAL",&dsoEnglishMod::ORDINAL);
}

void dsoEnglishMod::DAYNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYNAME",e_ParamNone);
  data=daynames[data.AsInt()%7];
}

void dsoEnglishMod::MONTHNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"MONTHNAME",e_ParamNone);
  data=monthnames[(data.AsInt()-1)%12];
}

void dsoEnglishMod::DAYSHORTNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYSHORTNAME",e_ParamNone);
  data=dayshortnames[data.AsInt()%7];
}

void dsoEnglishMod::MONTHSHORTNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYABBREV",e_ParamNone);
  data=monthshortnames[(data.AsInt()-1)%12];
}

void dsoEnglishMod::DAYABBREV(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=dayabbrevs[data.AsInt()%7];
}

void dsoEnglishMod::MONTHABBREV(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=monthabbrevs[(data.AsInt()-1)%12];
}

void dsoEnglishMod::ORDINAL(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  int num=data.AsInt()%10;
  data="th";
  switch(num){
  case 1: data="st"; break;
  case 2: data="nd"; break;
  case 3: data="rd"; break;
  }
}
