#include "polytype.h"
#include "dtutils.h"

PolyType::operator int()const{
  if(!m_isInt){
    switch(m_original){
    case wasDouble:
      m_int=(int)m_double;
      break;
    case wasString:
      m_int=atoi(m_string.c_str());
      break;
    case wasBool:
      m_int=m_bool?1:0;
      break;
    default: ;
    }
    m_isInt=true;
  }
  return m_int;
}

PolyType::operator double()const{
  if(!m_isDouble){
    switch(m_original){
    case wasInt:
      m_double=(double)m_int;
      break;
    case wasString:
      m_double=atof(m_string.c_str());
      break;
    case wasBool:
      m_double=m_bool?1.0:0.0;
      break;
    default: ;
    }
    m_isDouble=true;
  }
  return m_double;
}

PolyType::operator string()const{
  if(!m_isString){
    switch(m_original){
    case wasInt:
      m_string=IToS(m_int);
      break;
    case wasDouble:
      m_string=FToS(m_double);
      break;
    case wasBool:
      m_string=m_bool?"1":"0";
      break;
    default: ;
    }
    m_isString=true;
  }
  return m_string;
}

PolyType::operator bool()const{
  if(!m_isBool){
    switch(m_original){
    case wasInt:
      m_bool=m_int!=0;
      break;
    case wasDouble:
      m_bool=m_double!=0.0;
      break;
    case wasString:
      operator int();
      m_bool=m_int!=0;
      break;
    default: ;
    }
    m_isBool=true;
  }
  return m_bool;
}

PolyType& PolyType::operator=(const int v){
  m_isInt=true;
  m_isDouble=false;
  m_isString=false;
  m_isBool=false;
  m_original=wasInt;
  m_int=v;
  return *this;
}

PolyType& PolyType::operator=(const double v){
  m_isInt=false;
  m_isDouble=true;
  m_isString=false;
  m_isBool=false;
  m_original=wasDouble;
  m_double=v;
  return *this;
}

PolyType& PolyType::operator=(const string& v){
  m_isInt=false;
  m_isDouble=false;
  m_isString=true;
  m_isBool=false;
  m_original=wasString;
  m_string=v;
  return *this;
}

PolyType& PolyType::operator=(const char* v){
  return operator=(string(v));
}

PolyType& PolyType::operator=(const bool v){
  m_isInt=false;
  m_isDouble=false;
  m_isString=false;
  m_isBool=true;
  m_original=wasBool;
  m_bool=v;
  return *this;
}

int& PolyType::AsInt(){
  operator int();
  m_original=wasInt;
  m_isInt=true;
  m_isDouble=false;
  m_isString=false;
  m_isBool=false;
  return m_int;
}

double& PolyType::AsDouble(){
  operator double();
  m_original=wasDouble;
  m_isInt=false;
  m_isDouble=true;
  m_isString=false;
  m_isBool=false;
  return m_double;
}

string& PolyType::AsString(){
  operator string();
  m_original=wasString;
  m_isInt=false;
  m_isDouble=false;
  m_isString=true;
  m_isBool=false;
  return m_string;
}

bool& PolyType::AsBool(){
  operator bool();
  m_original=wasBool;
  m_isInt=false;
  m_isDouble=false;
  m_isString=false;
  m_isBool=true;
  return m_bool;
}

