#ifndef _SCREEN_H
#define _SCREEN_H 1

#include "input.h"

struct screen {
	char *buf;
	unsigned int li, co, len, start;
	void (*draw)(struct screen *);
	struct history_list history;
};

extern int scr_init (int li, int co);
extern void scr_line_up (struct screen *scr);
extern void scr_line_down (struct screen *scr);
extern void scr_page_home (struct screen *scr);
extern void scr_page_end (struct screen *scr);
extern void scr_page_up (struct screen *scr);
extern void scr_page_down (struct screen *scr);
extern void scr_draw (struct screen *scr);
extern void scr_resize (struct screen *scr, int li, int co);
extern void scr_resize_all (int li, int co);
extern void scr_puts (struct screen *scr, const char *buf, unsigned int len);

extern void curscr_puts (const char *buf, unsigned int len);
extern void curscr_printf (const char *fmt, ...) __attribute__((__format__(printf, 1, 2)));

extern void default_status_draw (struct screen *scr);

extern struct screen main_scr, *curscr;

#endif /* !_SCREEN_H */
