#define _GNU_SOURCE

#include "config.h"

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <syslog.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>

#include "log.h"

extern iac_server_configuration_t iac_cfg;


void
p_prepare(char *msg)
{
    int len = strlen(msg);

    for (--len;len > 0; len--) {
        if (msg[len] == '\n' || msg[len] == '\r')
            msg[len] = '\0';
        else
            break;
    }
}


void
iac_log(int level, const char *fmt, ...)
{
	va_list args;
	char *msg2 = NULL;
    char *msg = NULL;
    time_t t;

	va_start(args, fmt);
	vasprintf(&msg2, fmt, args);

    p_prepare(msg2);

    if ( iac_cfg.flags & IAC_TIMESTAMPS && !(iac_cfg.flags & IAC_DAEMON) ) {
        t = time(0);
        iac_astrcat(&msg, asctime(localtime(&t)));
        msg[strlen(msg)-1] = ' ';
    }

    iac_astrcat(&msg, msg2);

    RL_FREE(msg2);

	switch(level)
	{
		case IAC_RAW:

			if (iac_cfg.debug < 3)
				break;

		case IAC_DEBUG:
			if (iac_cfg.debug < 2)
				break;

		case IAC_VERBOSE:
			if (iac_cfg.debug < 1)
				break;

			if (iac_cfg.flags & IAC_DAEMON && !iac_cfg.chroot[0]) {
				syslog(LOG_DEBUG, "%s", msg);
				break;
			}

		case IAC_INFO:
		case IAC_IMPORTANT:
			if (iac_cfg.flags & IAC_DAEMON && !iac_cfg.chroot[0]) {
				syslog(LOG_INFO, "%s", msg);
			} else {
				printf("%s\n", msg);
                fflush(stdout);
			}
			break;
		case IAC_WARN:
			if (iac_cfg.flags & IAC_DAEMON && !iac_cfg.chroot[0]) {
				syslog(LOG_WARNING, "%s", msg);
			} else {
				fprintf(stderr, "%s\n", msg);
                fflush(stderr);
			}
			break;
		case IAC_ERR:
			if (iac_cfg.flags & IAC_DAEMON && !iac_cfg.chroot[0]) {
				syslog(LOG_ERR, "%s", msg);
			} else {
				fprintf(stderr, "%s\n", msg);
                fflush(stderr);
			}
			exit(-1);
			break;
	}

	free(msg);
	va_end(args);
}

void
iac_err(const char *fmt, ...)
{
    va_list args;

    va_start(args, fmt);
    if (iac_cfg.flags & IAC_DAEMON) {
        char *msg;
        vasprintf(&msg, fmt, args);
        syslog(LOG_ERR, "%s", msg);
        free(msg);
    } else {
        vfprintf(stderr, fmt, args);
    }
    va_end(args);

    fflush(stdout);
    exit(-1);
}

void
iac_warn(const char *fmt, ...)
{
    va_list args;

    va_start(args, fmt);
    if (iac_cfg.flags & IAC_DAEMON) {
        char *msg;
        vasprintf(&msg, fmt, args);
        syslog(LOG_WARNING, "%s", msg);
        free(msg);
    } else { 
        vfprintf(stderr, fmt, args);
    }
    va_end(args);
    
    fflush(stdout); 
}


