/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

//////////////////////////////////////////////////////////////////////////////////
// IceMenuSave.cpp implementation of CLASS IceMenuSave
//
// created:  mig 001010
// last mod: mig 001026
//
// description: goes through IceListView and writes IceListViewItems
//              to Menu Configuration File.
//////////////////////////////////////////////////////////////////////////////////

#include "IceMenuSave.h"
#include "IceListView.h"

#include<qfile.h>
#include<qstring.h>

///////////////////////////////////////////////////////////
// constructor & destructor
///////////////////////////////////////////////////////////

IceMenuSave::IceMenuSave() 
{
	;//qDebug("DEBUG: IceMenuSave::IceMenuSave()");
	step = 3;
}

IceMenuSave::~IceMenuSave() 
{
	;//qDebug("DEBUG: IceMenuSave::~IceMenuSave()");
}

///////////////////////////////////////////////////////////
// public methods
///////////////////////////////////////////////////////////

void IceMenuSave::write(IceListView* iceList, const QString filePath)
{
  ;//qDebug("DEBUG: IceMenuSave::write(IceListView* iceList, const QString filePath)");
  
  dest = new QFile(filePath);
  destStream = new QTextStream();
  
  if (dest->exists()) {
    // backup file
  }
  
  if (dest->isOpen()) {
    // error: file already open
  } else {
    dest->open(IO_WriteOnly);
    destStream->setDevice(dest);
    // parse
    writeList(iceList);
    // if (success) {
    //   close the file
    //   rm backup
    // } else {
    //   restore the file
    // }
    destStream->unsetDevice();
    dest->close();
  }
  
  delete dest;
  delete destStream;
}

/////////////////////////////////////////////////////////////
// private methods
/////////////////////////////////////////////////////////////

void IceMenuSave::writeList(IceListView* iceList)
{
  int depth = 0, actual = 0;
  QString out, info;
  IceListViewItem* item;
  QListViewItemIterator it(iceList);
  // iterate through all items of the listview
  while (it.current()) {
    out = "";
    item = dynamic_cast<IceListViewItem*> (it.current());
    depth = item->depth();
    if (depth != actual) {
      while (depth < actual) {
	actual--;
	out.fill(' ', actual*step);
	out = out + "}\n";
	*destStream << out;
	out = ""; // necessary?
      }
      actual = depth;
    }
    
    info = item->getInfo();
    out.fill(' ', actual*step);
    out += info + ' ';
    if (info == "menu") {
      out += '"' + item->text(0) + '"';
      
      if (item->text(1).isEmpty())
	out += " - {\n";
      else
	out += ' ' + item->text(1) + " {\n";
      
      *destStream << out;
      actual++;
    } else if ((info == "prog") || (info == "restart")) {
      out += '"' + item->text(0) + '"';
      
      if (item->text(1).isEmpty())
	out += " -";
      else
	out += ' ' + item->text(1);
      
      if (item->text(2).isEmpty())
	out += " -\n";
      else
	out += ' ' + item->text(2) + '\n';
      
      *destStream << out;
    } else if (info == "separator") {
      out += '\n';
      *destStream << out;
    } else if (info == "menufile" || "menuprog") {
      out += '"' + item->text(0) + '"';

      if (item->text(1).isEmpty())
	out += " -";
      else
	out += ' ' + item->text(1);
      
      if (item->text(2).isEmpty())
	out += " -\n";
      else
	out += ' ' + item->text(2) + '\n';
   
      *destStream << out;
    }
    ; // don't do anything // hae??
    it++;
  } // while
  while (0 < actual) {
    actual--;
    out.fill(' ', actual*step);
    out = out + "}\n";
    *destStream << out;
    out = ""; // necessary?
  }
}





