/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- XIdeskImage.h
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#ifndef XIDESK_IMAGE_CLASS
#define XIDESK_IMAGE_CLASS

#include "AbstractClasses.h"
#include <libpng/png.h>
#include "XDesktopContainer.h"
#include "DesktopConfig.h"
#include "DesktopIconConfig.h"
#include <X11/Xlib.h>
#include <Imlib.h>

class XIdeskImage : public AbstractImage
{
    protected:
        Window window;

        int x, y, width, height;

        bool hasAlpha;
        bool glowing;

        int transparency;

        unsigned char *rgb, *alpha, *alpha2;

        ImlibData * imlibData;
        ImlibImage * spareRoot;
    public:
        XIdeskImage(AbstractContainer * c, AbstractIcon * iParent,
                    AbstractConfig * con, AbstractIconConfig * iConfig);
        ~XIdeskImage();

        virtual void draw();

        virtual void configure();
        virtual void createPicture();

        virtual Window * getWindow();
        virtual void createWindow();
        virtual void lowerWindow();
        virtual void mapWindow();
        virtual void unmapWindow();
        virtual void moveWindow(int xCord, int yCord);

        virtual void refreshIcon();
        virtual void repaint();
        virtual void applyMouseOverEffects(ImlibImage * &background,
                                           unsigned char * &bgRgb);

        int getWidth() { return width; }
        int getHeight() { return height; }

        virtual void mouseOverEffect();
        virtual void mouseOffEffect();


};

#endif
