/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package com.sun.iiim;

import sun.awt.im.iiimp.*;

/**
 * This class represents Aux event.
 */
public class IIIMAuxEvent extends IIIMEvent {

    public static final int START    = 0;
    public static final int DRAW     = 1;
    public static final int DONE     = 2;
    public static final int SETVALUES = 3;

    private int index;
    private String name;
    private int[] intValues;
    private String[] stringValues;

    /**
     * Constructor for START/DONE event
     */
    public IIIMAuxEvent(int type, int index, String name) {
	// classIndex is for backward compatibility
	super(AUX);
	if (type != START && type != DONE) {
	    throw new IllegalArgumentException();
	}
	this.type = type;
	this.index = index;
	this.name = name;
    }

    /**
     * Constructor for DRAW/SETVALUES event
     */
    public IIIMAuxEvent(int type, int index, String name,
			int[] intValues, String[] stringValues) {
	super(AUX);
	if (type != DRAW && type != SETVALUES) {
	    throw new IllegalArgumentException();
	}
	this.type = type;
	this.index = index;
	this.name = name;
	this.intValues = intValues;
	this.stringValues = stringValues;
    }

    public int getIndex() {
	return index;
    }

    public String getName() {
	return name;
    }

    public int[] getIntValues() {
	return intValues;
    }

    public String[] getStringValues() {
	return stringValues;
    }
}
