/* 
 * Copyright 2003 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */

#include <stdio.h>
#include "SunIM.h"
#include "hzinput.h"

int map_keyevent_to_imekey(IMEKey key_event)
{
	int keycode = key_event->keyCode;
	int keychar = key_event->keyChar;
	int keystatus = key_event->modifier;

	DEBUG_printf("keycode: 0x%x, keychar:0x%x, keystatus: 0x%x\n", keycode, keychar, keystatus);

	/* Normal Alphameric key */
        if ((keycode >= IM_VK_COMMA && keycode <= IM_VK_CLOSE_BRACKET) ||
	    (keycode == IM_VK_QUOTE) || (keycode == IM_VK_BACK_QUOTE)) {
		if (! (keystatus & IM_CTRL_MASK) &&
		    ! (keystatus & IM_META_MASK) &&
		    ! (keystatus & IM_ALT_MASK) &&
		    ! (keystatus & IM_ALT_GRAPH_MASK) )
			return(keychar);
	}

	/* Special key */
	if (keystatus == 0) {
		switch (keycode) {
			case IM_VK_ESCAPE:
				return(ESC_KEY);

			case IM_VK_BACK_SPACE:
				return(BACKSPACE_KEY);

			case IM_VK_ENTER:
				return(RETURN_KEY);

			case IM_VK_SPACE:
				return(SPACE_KEY);

			case IM_VK_DELETE:
				return(DELETE_KEY);

			case IM_VK_PAGE_UP:
				return(PAGEUP_KEY);

			case IM_VK_PAGE_DOWN:
				return(PAGEDOWN_KEY);
		}
	}
	return (IME_NOT_USED_KEY);
}

