/*
 * Copyright (c) 1999 Sun Microsystems, Inc.
 * Copyright (c) 1999 Nihon Sun Microsystems K.K.
 * All rights reserved.
 */

#ifndef _CSC_CT_MAP_H
#define _CSC_CT_MAP_H

/*
 * "$Id: ct_map.h,v 1.1.1.1 2000/10/29 16:44:42 himi Exp $"
 */

#pragma ident	"@(#)ct_map.h 1.2	99/04/28 SMI"

#ifdef	__cplusplus
extern "C" {
#endif


#define	CT_MAP_CONF	"./ct_map.conf"

#define	ENC_GL			(0)
#define	ENC_GR			(1)
#define	ENC_GLGR		(2)

#define	ENC_GL_STR		"GL"
#define	ENC_GR_STR		"GR"
#define	ENC_GLGR_STR		"GLGR"


typedef struct _ct_map_conf {
	int			cs_num;
	int			extended_segment;
	char *			enc_name;
	char *			path_data;
	char *			path_u_n;
	char *			path_n_u;
	char *			stem;
	int			index_n;
	int			index_u;
	int			enc_gl_gr;
	char *			enc_gl_gr_str;
	int			byte_number;
	char *			design_name;
	unsigned char *		design_str;
	int			design_length;
	char *			cs_u_n_map_name;
	char *			cs_n_u_map_name;
	unsigned int		cs_id;
	struct _ct_map_conf *	next;
} ct_map_conf_t;


typedef struct _euc_ct_set_conf {
	char *				euc_id;
	char *				cs_name[4];
	int				cs_glgr[4];
	int				cs_len[4];
	struct _euc_ct_set_conf *	next;
} euc_ct_set_conf_t;


extern ct_map_conf_t *	parse_ct_map_conf(void);


#ifdef	__cplusplus
}
#endif

#endif /* !_CSC_CT_MAP_H */
