/* $Id: im-forward-event-with-operations.c,v 1.1.1.1 2002/08/31 04:18:05 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_forward_event_with_operations_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_contents *	contents,
    IIIMP_operation *	operation)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_FORWARD_EVENT_WITH_OPERATIONS;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.forward_event_with_operations.contents = contents;
    m->v.forward_event_with_operations.operation = operation;
    return m;
}


void
iiimp_forward_event_with_operations_delete(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    if (NULL == m) return;
    iiimp_contents_delete(data_s, m->v.forward_event_with_operations.contents);
    iiimp_operation_list_delete(data_s,
				m->v.forward_event_with_operations.operation);
    free(m);
    return;
}


uchar_t *
iiimp_forward_event_with_operations_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_contents *	contents,
    IIIMP_operation *	operation_list,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;
    size_t		op_list_nbyte;
    IIIMP_operation *	o;

    nbyte = 0;
    nbyte += 2;			/* input method id */
    nbyte += 2;			/* input contents id */
    nbyte += contents->nbyte;	/* forwarded string of text */
    nbyte += 4;			/* byte length of operation list */
    for (op_list_nbyte = 0, o = operation_list; NULL != o; o = o->next) {
	op_list_nbyte += o->nbyte;
    }
    nbyte += op_list_nbyte;	/* operation list */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_FORWARD_EVENT_WITH_OPERATIONS, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    iiimp_contents_pack(data_s, contents, &rest, &p);
    PUTU32(op_list_nbyte, rest, p, data_s->byte_swap);
    iiimp_operation_list_pack(data_s, operation_list, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_forward_event_with_operations_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *				m;
    IIIMP_forward_event_with_operations_v *	v;
    size_t					rest;
    const uchar_t *				p;
    int						len;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.forward_event_with_operations);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);

    v->contents = iiimp_contents_unpack(data_s, &rest, &p, rest);
    if (NULL == v->contents) {
	free(m);
	return NULL;
    }

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    v->operation = iiimp_operation_list_unpack(data_s, &rest, &p, len);
    if (NULL == v->operation) {
	iiimp_contents_delete(data_s, v->contents);
	free(m);
	return NULL;
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_forward_event_with_operations_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    iiimp_contents_print(data_s, m->v.forward_event_with_operations.contents);
    iiimp_operation_print(data_s, m->v.forward_event_with_operations.operation);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
