""" Export dialog implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: ExportWnd.py,v 1.30 2004/03/03 22:32:53 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.30 $"

from string import *
import traceback,os

try:
    from ExportForm import *
    from dbExportXML import *
    from dbExportCSV import *
except:
    traceback.print_exc()
    pass

class ExportWnd(ExportForm):

    def __init__(self, parent,env):
        ExportForm.__init__(self,parent)
        self.env = env
        self.curdb = self.env.curdb
        self.curdb.cbs["Batch"].append(self.syncBatchCombo)
        self.curBatch = -1
        self.batchgroup.hide()
        self.syncBatchCombo()

    def onReset(self):
        """user ordered batch content to be reset """
        if self.curBatch==-1: return
        self.curdb.resetBatch(self.curBatch)

    def batchcombo_activated(self,a0):
        try:
            bid = self.curdb.batches.keys()[a0]
        except:
            print "key Error showing desired batch"
            return
        self.curBatch = bid

    def syncBatchCombo(self,what = None):
        """call it to sync curdb batch list to what the ui shows on the batch combobox"""
        self.batchcombo.clear()
        if not self.curdb.batches.keys():return
        for bid in self.curdb.batches.keys():
            self.batchcombo.insertItem(self.curdb.batches[bid][0])
        self.curBatch = self.curdb.batches.keys()[0]

    def batchcheck_toggled(self,a0):
        if not a0:
            self.batchgroup.hide()
        else:
            self.batchgroup.show()

    def expallradio_toggled(self,a0):
        if a0:
            self.batchgroup.hide()
        else:
            self.batchgroup.show()

    def morebtn_clicked(self):
        filename = str(QFileDialog.getExistingDirectory())
        if not filename:return
        if filename[-1] != os.sep: filename = filename+os.sep
        self.destpathedit.setText(filename)

    def exportbtn_clicked(self):
        batch = []
        opts = {}
        destp = str(self.destpathedit.text())
        if not os.path.exists(destp):
            QMessageBox.information( self, "imgSeek","Invalid destination dir.")
            return
        if not os.path.isdir(destp):
            QMessageBox.information( self, "imgSeek","Invalid destination dir.")
            return
        if destp[-1] != os.sep: destp = destp+os.sep
        opts["outdir"] = destp
        if self.expallradio.isChecked(): # export all
            # create a virtual batch with all volumes and send
            batch = []
            for grp in self.curdb.volumes.keys():
                batch.append(["Volume",grp])
        else:                           # only a batch
            if self.curBatch== -1:
                QMessageBox.information( self, "imgSeek","You must define a batch first.")
                return
            try:
                batch = self.curdb.batches[self.curBatch][1]
            except:
                traceback.print_exc()
                QMessageBox.information( self, "imgSeek","Error getting selected batch.")
                return
        if self.xmlradio.isChecked():   # XML
            dbE = dbExportXML(self.curdb,opts,batch)
        else:                           # CSV
            dbE = dbExportDSV(self.curdb,opts,batch)
        QMessageBox.information( self, "imgSeek", dbE.do()) # show error or success msg

    def cancelbtn_clicked(self):
        self.close()

    def xmlradio_toggled(self,a0):
        pass

    def batchedbtn_clicked(self):
        self.parent().editcategaction_activated()
