/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/gdk/gl/font.h
//! @brief A C++ wrapper interface for the GtkGLExt font functions.

#ifndef INTI_GDK_GL_FONT_H
#define INTI_GDK_GL_FONT_H

#ifndef INTI_PANGO_FONT_H
#include <inti/pango/font.h>
#endif

#ifndef __GDK_GL_FONT_H__
#include <gdk/gdkglfont.h>
#endif

namespace Inti {

namespace Gdk {

class Display;

namespace GL {

//! @name Font Methods
//! @{

Pango::Font*
font_use_pango_font(const Pango::FontDescription& font_desc, int first, int count, int list_base, const Display *display = 0);
//!< Creates bitmap display lists from a Pango::Font.
//!< @param font_desc A Pango::FontDescription describing the font to use.
//!< @param first The index of the first glyph to be taken.
//!< @param count The number of glyphs to be taken.
//!< @param list_base The index of the first display list to be generated.
//!< @param display A Gdk::Display, or null for the default display.
//!< @return The Pango::Font used, or null if no font matched.

//! @}

} // namespace GL

} // namespace Gdk

} // namespace Inti

#endif // INTI_GDK_GL_FONT_H

