<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("tech");
if(@$commit != 1)
{
	commonHeader(_("Knowledge Base") . " - " . _("Add Article"));
	if(isset($from_tracking))
	{
		$track = new Tracking($from_tracking);
		$question = $track->getWorkRequest();
		$answer = $track->getFollowupsInfo();
		if($answer == "")
		{
			$answer = _("No followups were added, please put something here in the answer!");
		} 
	}
	
	__("Here is where you can add an article to the knowledge base.");
	?>
	<hr noshade>
	<BR>
	<form method=post action="<?php echo Config::AbsLoc('users/knowledgebase-article-preview.php') ?>">
	<?php __("Select the category in which this article should be placed:");?>
	<?php kbcategoryList(@$categorylist); ?>
	<br>
	<br>
	<?php __("Enter the question here.  Please be as detailed as possible with the 
		question, but don't repeat information that can be inferred by the category.");
	?>
	<br>
	<?php
	if (!@$question)
	{
		$question = '';
	}
	PRINT "<textarea cols=50 rows=14 wrap=soft name=question>$question</textarea>"; 
	?>
	<br>
	<?php __("Enter the answer here.  Please be as detailed as possible with the answer, including a step by step process."); ?>
	<br>
	<?php
	if (!@$answer)
	{
		$answer = '';
	}
	PRINT "<textarea cols=50 rows=14 wrap=soft name=answer>$answer</textarea>"; 
	PRINT "<br>\n";
if (@$faq)
{
	$faqchecked = ' checked';
}
else
{
	$faqchecked = '';
}
	PRINT "<input type=checkbox name=faq value=\"yes\"$faqchecked> "._("Place this Knowledge Base Article into the publicly viewable FAQ as well.")." <BR>\n";
	PRINT "<input type=submit value=\""._("Preview Article")."\"> <input type=reset value=\""._("Reset")."\"></form>";
} else
{
	$DB = Config::Database();
	if($modify == 1)
	{
		commonHeader(_("Knowledge Base") . " - " ._("Article Modified"));
		$vals = array(
			'categoryID' => $categorylist,
			'question' => $question,
			'answer' => $answer,
			'faq' => $faq
			);

		$qID = $DB->getTextValue($ID);
		$DB->UpdateQuery('kbarticles', $vals, "ID=$qID");
		
		__("Article has been modified. ");
		PRINT '<A HREF="'.Config::AbsLoc("users/knowledgebase-detail.php?ID=$ID").'">'._('Go Back').'</A>';
	} else
	{
		commonHeader(_("Knowledge Base") . " - " ._("Article Added"));
		$vals = array(
			'categoryID' => $categorylist,
			'question' => $question,
			'answer' => $answer,
			'faq' => $faq
			);
		$DB->InsertQuery('kbarticles', $vals);
		__("Article has been added. ");
		PRINT '<A HREF="'.Config::AbsLoc('users/knowledgebase-index.php').'">'._("Go Back").'</A>';
	}
}
commonFooter();
