<?php
#    IRM - The Information Resource Manager
#
#    Software Report Module
#    Copyright (C) 2002 Big Walnut Local Schools
#    written by David Maxwell, Technician Big Walnut Local Schools
#    Contains altered code from irm.inc and default.php files included with
#    the 1.3.4 version of IRM.         
#    
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################
#                                  CHANGELOG                                   
#
#  v0.01 First functional version of Software Report Module                    
#  v0.02 Better formatting of number of installs, name of software in question
#        printed on the reports.
#
#  v0.03 Ability to sort results added.
#  v0.1  Configurable number of results per search page.
#  v0.11 Results pages have link to return to the modules's main menu. Functions
#        commented.
#
#  v0.2  Code cleanups.  Rewrote and renamed the function that was used to 
#        obtain the number of installs.  Some of the code was in the main
#        menu portion of the module.  It worked but was ugly.  This rewrite
#        simplified both the main menu and the function in question.
#
#  v0.3  Module will now report a software package if it has been installed
#        through a bundle.  It will also report how many from a bundle and
#        indicate which machines having the package are installed in that
#        bundle.  Included code from irm.inc cleaned up and even more 
#        heavily altered to make the bundle reporting work.  Also eliminated
#        the numInstalledShow function. softwareComputerListView now returns
#        the number of installs.
#
#        The software bundle changes break the code that limits the number 
#        of rows in the html table.  The code is still present but commented
#        out until I can figure out how to fix it.
#
#  v0.4  Ability to select number of results per HTML page re-enabled. Added
#        newlines to end of strings that generate HTML for HTML source
#        readability. 
#
#  v0.41 Computer ID correctly displayed in reports.  Fix contributed by
#        Stephen J. Lawrence Jr. <slawrence@ucdavis.edu>
#
#  v0.5  Made compatible with IRM 1.5.x. Will no longer work with 1.4.x and
#        before.
#
#  v0.51 Missed a bug in autogenerated computers-info.php URLs. Fixed.
################################################################################
#  NOTE
#
#  The format of the report is the same as Computers list view and is        
#  controlled by the same preferences.            
################################################################################

require_once '../../include/irm.inc';
require_once 'include/reports.inc.php';
require_once 'lib/Config.php';

AuthCheck("normal");

# softwareComputerListView function actually generates the results
# table when called with the appropriate argument.  This is a modified
# version of the ComputerListView function from irm.inc. It requires
# a software ID, sort criteria (one of computers table column name),
# and the number of results per page of HTML.  It generates on screen
# tables and returns the number of installs of the software in question.

function softwareComputerListView($sID, $sort, $numresults) 
{

  global $IRMName, $field, $goto, $contains, $style, $bgcl, $bgcd, $USERPREFIX;
  
  $USERPREFIX=Config::AbsLoc('users');

  $DB = Config::Database();
  $uname = $DB->getTextValue($IRMName);
                        
  $query = "SELECT * FROM prefs WHERE (user = $uname)";
                                
  $result = $DB->getRow($query);
  
  $stype = $result["type"];
  $sos = $result["os"];
  $sosver = $result["osver"];
  $sprocessor = $result["processor"];
  $sprocessor_speed = $result["processor_speed"];
  $slocation = $result["location"];
  $sserial = $result["serial"];
  $sotherserial = $result["otherserial"];
  $sramtype = $result["ramtype"];
  $snetwork = $result["network"];
  $sram = $result["ram"];
  $sip = $result["ip"];      
  $smac = $result["mac"];
  $shdspace = $result["hdspace"];  
  $scontact = $result["contact"];
  $scontact_num = $result["contact_num"];
  $scomments = $result["comments"];
  $sdate_mod = $result["date_mod"];

  $stype = Checked($stype);
  $sos = Checked($sos);
  $sosver = Checked($sosver);
  $sprocessor = Checked($sprocessor);
  $sprocessor_speed = Checked($sprocessor_speed);
  $slocation = Checked($slocation);
  $sserial = Checked($sserial);
  $sotherserial = Checked($sotherserial);
  $sramtype = Checked($sramtype);
  $sram = Checked($sram);
  $snetwork = Checked($snetwork);
  $sip = Checked($sip);
  $smac = Checked($smac);
  $shdspace = Checked($shdspace);
  $scontact = Checked($scontact);
  $scontact_num = Checked($scontact_num);
  $scomments = Checked($scomments);
  $sdate_mod = Checked($sdate_mod);
   
 
  PRINT "<TABLE BORDER=1 WIDTH=100%><tr $bgcd>\n";
 
  PRINT "<th>"._("Name")."</th>";

  $numChecked = 1;
   
  if ($stype == "checked") 
  {
    PRINT "<th>"._("Type")."</th>";
    $numChecked++;  
  }
  if ($sos == "checked") 
  {
    PRINT "<th>"._("OS")."</th>";
    $numChecked++;  
  }
  if ($sosver == "checked") 
  {
    PRINT "<th>"._("OS Version")."</th>";
    $numChecked++;  
  }
  if ($sprocessor == "checked") 
  {
    PRINT "<th>"._("Processor")."</th>";
    $numChecked++;  
  }
  if ($sprocessor_speed == "checked") 
  {
    PRINT "<th>"._("Proc. Speed")."</th>";
    $numChecked++;  
  }
  if ($slocation == "checked") 
  {
    PRINT "<th>"._("Location")."</th>";
    $numChecked++;  
  }
  if ($sserial == "checked") 
  {
    PRINT "<th>"._("Serial Number")."</th>";
    $numChecked++;  
  }
  if ($sotherserial == "checked") 
  {
    PRINT "<th>"._("Other Serial Number")."</th>";
    $numChecked++;  
  }
  if ($sramtype == "checked") 
  {
    PRINT "<th>"._("RAM Type")."</th>";
    $numChecked++;  
  }
  if ($sram == "checked") 
  {
    PRINT "<th>"._("RAM Amount (in MB)")."</th>";
    $numChecked++;  
  }
  if ($snetwork == "checked") 
  {
    PRINT "<th>"._("Network")."</th>";
    $numChecked++;  
  }
  if ($sip == "checked")
  {
    PRINT "<th>"._("IP")."</th>";
    $numChecked++;  
  }
  if ($smac == "checked")
  {
    PRINT "<th>"._("Net/MAC Addr")."</th>";
    $numChecked++;  
  }
  if ($shdspace == "checked") 
  {
    PRINT "<th>"._("HD Space")."</th>";
    $numChecked++;  
  }
  if ($scontact == "checked") 
  {
    PRINT "<th>"._("Contact Person")."</th>";
    $numChecked++;  
  }
  if ($scontact_num == "checked") 
  {
    PRINT "<th>"._("Contact Number")."</th>";
    $numChecked++;  
  }
  if ($scomments == "checked") 
  {
    PRINT "<th>"._("Comments")."</th>";
    $numChecked++;  
  }
  if ($sdate_mod == "checked") 
  {
    PRINT "<th>"._("Date Modified")."</th>";
    $numChecked++;  
  }
   
  PRINT "</TR>\n";


  $bundle_query = "SELECT bID from software_bundles where sID=$sID";
  $bundles = $DB->getAll($bundle_query);
  $numbundles = count($bundles);
  $package[0] = $sID; 

  $i = 1;
  foreach ($bundles as $result)
  {
   $package[$i] = $result["bID"];
   $i++;
  }

  $where_clause = "inst_software.sID=";
  
  $i = 0;
  
  foreach($package as $v)
  {
   if ($i == 0)
   $where_clause = "$where_clause"."$v";
   if ($i > 0)
   $where_clause = "$where_clause"." OR inst_software.sID=$v";
   $i++;
  }

 $packagename = softwareName($v);
 $softquery = "SELECT * FROM computers LEFT JOIN inst_software ON computers.ID=inst_software.cID WHERE
        $where_clause ORDER by sID,$sort";  
 
 $data = $DB->getAll($softquery);
 $numRows = count($data);
           
 # Chop off any records we want to skip
         
 $data = array_slice($data, $goto);
 if (count($data) > $numresults)
 {
  $nextpage = true;
  $data = array_slice($data, 0, $numresults);
 }
  else
 {
  $nextpage = false;
 }
                                

 foreach ($data as $result)
 {
        
  $ID = $result["cID"];
  $soft_id = $result["sID"];
  $name = $result["name"];
  $type = $result["type"];
  $os = $result["os"];
  $osver = $result["osver"];
  $processor = $result["processor"];
  $processor_speed = $result["processor_speed"];
  $location = $result["location"];
  $serial = $result["serial"];
  $otherserial = $result["otherserial"];
  $ramtype = $result["ramtype"];
  $ram = $result["ram"];
  $network = $result["network"];
  $ip = $result["ip"];
  $mac = $result["mac"];
  $hdspace = $result["hdspace"];
  $comments = $result["comments"];
  $date_mod = $result["date_mod"];
  $contact = $result["contact"];
  $contact_num = $result["contact_num"]; 
  $comments = $comments;
  
  if($previous_soft != $soft_id)
  {
   $query = "SELECT name FROM computers LEFT JOIN inst_software ON computers.ID=inst_software.cID WHERE inst_software.sID=$soft_id";
   $sth4 = $DB->getAll($query);
   $soft_num = count($sth4);
   $soft_name = softwareName($soft_id);
   print "<TR><TD align=\"center\" COLSPAN=\"$numChecked\"><b>$soft_name - $soft_num</b></TD></TR>\n";
  }

  PRINT "<TR BGCOLOR=#DDDDDD><TD><A HREF=\"$USERPREFIX/computers-info.php?ID=$ID\">$name($ID)</A></TD>\n";

  if ($stype == "checked")
  {
   PRINT "<TD>$type</TD>";
  }
  if ($sos == "checked")
  {
   PRINT "<TD>$os</TD>";
  }
  if ($sosver == "checked")
  {
   PRINT "<TD>$osver</TD>";
  }
  if ($sprocessor == "checked") 
  {
   PRINT "<TD>$processor</TD>";
  }
  if ($sprocessor_speed == "checked")
  {
   PRINT "<TD>$processor_speed</TD>";
  }
  if ($slocation == "checked") 
  {
   PRINT "<TD>$location</TD>";
  }
  if ($sserial == "checked") 
  {
   PRINT "<TD>$serial</TD>";
  }
  if ($sotherserial == "checked")
  {
   PRINT "<TD>$otherserial</TD>";
  }
  if ($sramtype == "checked") 
  {
   PRINT "<TD>$ramtype</TD>";
  }
  if ($sram == "checked") 
  {
   PRINT "<TD>$ram</TD>";
  }
  if ($snetwork == "checked") 
  {
   PRINT "<TD>$network</TD>";
  }
  if ($sip == "checked") 
  {
   PRINT "<TD>$ip</TD>";
  }
  if ($smac == "checked")
  { 
   PRINT "<TD>$mac</TD>";
  }
  if ($shdspace == "checked")
  {
   PRINT "<TD>$hdspace</TD>";
  }
  if ($scontact == "checked") 
  {
   PRINT "<TD>$contact</TD>";
  }
  if ($scontact_num == "checked") 
  {
   PRINT "<TD>$contact_num</TD>";
  }
  if ($scomments == "checked") 
  {
   PRINT "<TD>$comments</TD>";
  }
  if ($sdate_mod == "checked") 
  {
   PRINT "<TD>$date_mod</TD>";
  }
    
   PRINT "</TR>\n";
 

  $previous_soft = $soft_id;
   
 }
  
  $backgoto = $goto - $numresults;
  $forgoto = $goto + $numresults;
  PRINT "</TABLE>\n";
  PRINT "<TABLE BORDER=0><TR><TD>\n";
    
  if ($backgoto > -1)
  {
   PRINT "<form><input type=hidden name=goto value=$backgoto>
   <input type=hidden name=Show value=\"yes\">
   <input type=hidden name=sID value=$sID>
   <input type=hidden name=sort value=$sort>
   <input type=hidden name=numresults value=$numresults>
   <input type=submit value=\"".sprintf(_("Previous %s"), $numresults)."\"></form>\n";
  }

  PRINT "</TD><TD>\n";

  if ($forgoto < $numRows)
  {  
   PRINT "<form><input type=hidden name=goto value=$forgoto>
   <input type=hidden name=Show value=\"yes\">
   <input type=hidden name=sID value=$sID>
   <input type=hidden name=sort value=$sort>
   <input type=hidden name=numresults value=$numresults>
   <input type=submit value=\"".sprintf(_("Next %s"), $numresults)."\"></form>\n";
   $nextpage = 1;
  }

   PRINT "</TD></TR></TABLE>\n";
   return($numRows); 
}


# softwareName returns the name of an installed software package when 
# passed a numeric software ID.
 
function softwareName($softID)
{
 $DB = Config::Database();
 $query = "SELECT name FROM software WHERE ID = $softID";
 $sth = $DB->getRow($query);
 $software = $sth["name"];
 return ($software);
} 

# The following code generate the main menu and results tables.

$USERPREFIX=Config::AbsLoc('users/reports');

if ($Show == "yes")
{ 


 commonHeader(_("Software Installation Report"));
 print '<link href="../../style.css" rel="stylesheet" type="text/css">';
 
 $software_name = softwareName($sID); 
        
 PRINT "<BR><BR><BR>\n";
 PRINT "<TABLE BORDER=1 WIDTH=100%><TR BGCOLOR=#BBBBB><th colspan=2>\n";
 printf(_("Machines that have %s installed, sorted by %s"), "<i>$software_name</i>", "<i>$sort</i>");
 PRINT "\n</th></TR>\n";
 $numinstalled=softwareComputerListView($sID,$sort, $numresults);
 PRINT "</TABLE>\n";

        
 PRINT "<br><tr><td><b>"._("Number of Installs:")."</td><td>$numinstalled</b></td></tr></br>\n";
 printf('<a href="%s">%s</a>', Config::AbsLoc("users/reports/software.php"), _("Create a new Software Report"));

 commonFooter();
}
else
{
	PRINT "<html><body bgcolor=#ffffff>\n";
	print '<link href="../../style.css" rel="stylesheet" type="text/css">';

	commonHeader(_("Software Install Report"));

	__("Welcome to the Software Install Report! This will tell which machines have a particular software package installed.");
	PRINT "\n<BR><BR><BR>\n";
	PRINT "<table border=1 width=100%><tr><th>\n";
	__("Select A Software Package");
	PRINT "\n</th></tr>\n";
	PRINT "<tr bgcolor=#DDDDDD><TD>";

	PRINT "<form action=\"".Config::AbsLoc('users/reports/software.php')."\">";
      
	SoftwareDropdown( "dropdown_software");
	PRINT "</select>\n";

	$selbox = "<select name=sort size=1>
		<option value=\"name\">"._("Name")."/option>
		<option value=\"ID\">"._("IRM ID")."/option>
		<option value=\"location\">"._("Location")."/option>
		<option value=\"type\">"._("Type")."/option>
		<option value=\"os\">"._("Operating System")."/option>
		<option value=\"osver\">"._("Operating System Version")."/option>
		<option value=\"processor\">"._("Processor")."/option>
		<option value=\"processor_speed\">"._("Processor Speed")."/option>
		<option value=\"serial\">"._("Serial Number")."/option>
		<option value=\"otherserial\">"._("Other Number")."/option>
		<option value=\"ramtype\">"._("RAM Type")."/option>
		<option value=\"ram\">"._("RAM Amount")."/option>
		<option value=\"network\">"._("Network Card Type/Brand")."/option>
		<option value=\"ip\">"._("IP Address")."/option>
		<option value=\"mac\">"._("MAC/Network Address")."/option>
		<option value=\"hdspace\">"._("Hard Drive Capacity")."/option>
		<option value=\"comments\">"._("Comments")."/option>
		<option value=\"contact\">"._("Contact Person")."/option>
		<option value=\"contact_num\">"._("Contact Number")."/option>
		<option value=\"date_mod\">"._("Date Last Modified")."/option>
		</select>";

	printf(_("sorted by %s"), $selbox);

	printf(_("with %s results per page"), "<select name=numresults size=1>
				<option value=\"15\">15</option>
				<option value=\"25\">25</option>
				<option value=\"35\">35</option>
				<option value=\"50\">50</option>
				<option value=\"100\">100</option>
				</select>");

	PRINT "<input type=submit value=\""._("Show")."\"><input type=hidden name=Show value=yes>\n";
	PRINT "</form>\n";
	PRINT "</TD>\n";
	PRINT "</TR>\n";
	PRINT "</TABLE>\n";
	commonFooter();
	PRINT "</body></html>\n";
}
