<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("post-only");
commonHeader(_("FastTrack"));
__("Welcome to IRM FastTrack.  This is where tracking can be entered, assigned, and given a specific status all on one page.  Simply fill in the form below:"); 

$query = "select * from fasttracktemplates where (ID=$AUTOFILL)";
$DB = Config::Database();
$result = $DB->getRow($query);
$name = $result["name"];
$priority = $result["priority"];
$request = htmlspecialchars($result["request"]);
$response = htmlspecialchars($result["response"]);

$user = new User($IRMName);
$uemail = $user->getEmail();
$ufname = $user->getFullname();

__("Enter the IRM ID");
if(Config::Get('groups'))
{
	__("or group.  Make sure that you have selected the proper button to the left as well to indicate which identifier you are providing.");
	PRINT "\n<BR>";
}
PRINT "<HR NOSHADE>\n";

PRINT '<FORM METHOD=get ACTION="'.Config::AbsLoc('users/tracking-fasttrack-add.php').'">';
PRINT "<table border=1 width=100%><tr><th>";
__("Computer");
if(Config::Get('groups'))
{
	PRINT "/";
	__("Group");
}
__(" Information");
PRINT "</th></tr>";
PRINT "<tr bgcolor=#DDDDDD><TD>";
PRINT "<INPUT TYPE=\"RADIO\" NAME=\"IDTYPE\" VALUE=\"IRMID\"><STRONG>";
__("IRM ID: ");
PRINT "</STRONG><INPUT TYPE=text NAME=ID SIZE=10>&nbsp;&nbsp;\n";
PRINT "<BR>\n";
if(Config::Get('groups'))
{
	PRINT "<INPUT TYPE=\"RADIO\" NAME=\"IDTYPE\" VALUE=\"GROUP\"> ";
	PRINT "<STRONG>";
	__("Select a group:");
	PRINT "</STRONG>";
	Dropdown_groups("groups", "gID");
}
PRINT "</TD>\n";
PRINT "</TR>\n";
PRINT "</TABLE>\n";
PRINT "<br>\n";
PRINT "<table border=1 width=100%><tr><th>";
__("User Information");
PRINT "</th></tr>";
PRINT "<tr bgcolor=#DDDDDD><TD>";
PRINT "<strong>";
__("User's Name:");
PRINT "</strong>\n";
PRINT "<input type=text size=15 name=ufname value=\"$ufname\">";
PRINT "<br><br>\n";
PRINT "<strong>";
__("User's E-Mail:");
PRINT "</strong>\n";
PRINT "<input type=text name=uemail size=19 value=\"$uemail\">";
PRINT "</TD>\n";
PRINT "</TR>\n";
PRINT "</TABLE>\n";
PRINT "<br>\n";
PRINT "<table border=1 width=100%><tr><th>";
__("Work Request Information");
PRINT "</th></tr>";
PRINT "<tr bgcolor=#DDDDDD><TD>";
PRINT "<STRONG>";
__("Priority:");
PRINT "</STRONG> <SELECT NAME=priority>\n";
PRINT "<OPTION VALUE=5";
if($priority == 5)
{
	PRINT " selected";
}
PRINT ">Very High</OPTION>\n";
PRINT "<OPTION VALUE=4";
if($priority == 4)
{
	PRINT " selected";
}
PRINT ">High</OPTION>\n";
PRINT "<OPTION VALUE=3";
if($priority == 3)
{
	PRINT " selected";
}
PRINT ">Normal</OPTION>\n";
PRINT "<OPTION VALUE=2";
if($priority == 2)
{
	PRINT " selected";
}
PRINT ">Low</OPTION>\n";
PRINT "<OPTION VALUE=1";
if($priority == 1)
{
	PRINT " selected";
}
PRINT ">Very Low</OPTION>\n";
PRINT "</SELECT>\n";
PRINT "<BR>\n";
PRINT "<BR>\n";
PRINT "<STRONG>";
__("Describe the problem:");
PRINT "</STRONG>\n";
PRINT "<BR>\n";
PRINT "<textarea cols=50 rows=4 wrap=soft name=\"contents\">$request</textarea>"; 
PRINT "<BR><BR>\n";
PRINT "<STRONG>";
__("Describe the solution (will be added as a followup):");
PRINT "</STRONG>\n";
PRINT "<BR>\n";
PRINT "<textarea cols=50 rows=4 wrap=soft name=\"solution\">$response</textarea>\n"; 
PRINT "</TD>\n";
PRINT "</TR>\n";
PRINT "</TABLE>\n";
PRINT "<BR>\n";
PRINT "<table border=1 width=100%><tr><th>";
__("Additional Information");
PRINT "</th></tr>";
PRINT "<tr bgcolor=#DDDDDD><TD>";
PRINT "<STRONG>";
__("Assign to:");
PRINT "</STRONG>\n";
$track = new Tracking(@$ID);
$assign = $track->getAssign();
if($assign != "")
{
	Tech_list($assign, "user");
} else
{
	Tech_list("","user");
}

PRINT "<BR><BR>\n";
PRINT "<STRONG>";
__("Set Status to:");
PRINT "</STRONG>\n";


PRINT "<SELECT NAME=status SIZE=1>";
PRINT "<OPTION VALUE=\"active\">";
__("Active");
PRINT "</OPTION>";
PRINT "<OPTION VALUE=\"assigned\">";
__("Assigned");
PRINT "</OPTION>";
PRINT "<OPTION VALUE=\"complete\">";
__("Complete");
PRINT "</OPTION>";
PRINT "<OPTION VALUE=\"new\" selected>";
__("New");
PRINT "</OPTION>";
PRINT "<OPTION VALUE=\"old\">";
__("Old");
PRINT "</OPTION>";
PRINT "<OPTION VALUE=\"wait\">";
__("Wait");
PRINT "</OPTION>";
PRINT "</SELECT>";

PRINT "<BR><BR><input type=checkbox name=addtoknowledgebase value=yes >";
__("If tracking is marked as complete, should it be used to add something to the knowledgebase?");
PRINT "</td></tr>\n";
PRINT "</table>";
PRINT "<table border=0 width=100%><TR><TD><input type=submit value=Submit></TD><tr></table>";
PRINT "</form>";
PRINT "<br>";
commonFooter();
