#!/usr/bin/perl -w
# spell.pl 0.5.0
# 
# Skriptas(imho jau iaugo i "skriptuko" dydio bei funkcionalumo) naujiems 
# lietuvikiems ispell odynams sudarinti. Skaito odius, ir jeigu neapibrti 
# jokie flagai, isiaikina, koki reikia, bei isaugo od /~ esaniuose odynuose
# i kuri, vliau, kompiliuojamas pagrindinis ispell odynas.
#
# Vartojimas:
# spell.pl                       # skaito odius i klaviatros
# spell.pl odynas               # skaito i failo odynas
#
# Para Laimonas Vbra <l.v@centras.lt> stipriai patobulins skript, kur
# para Gediminas Paulauskas <menesis@delfi.lt>, patobulins skriptus i
# Alberto Agejevo <alga@uosis.mif.vu.lt> bei Mariaus Gedmino <mgedmin@delfi.lt>. :)
# 
# TODO:
# * daugiau intelekto atspjant odi formas
# * parametrais nurodomos vesties/ivesties bylos 
# # ispell odyno kompiliavimas
# # UI pagerinimas, galbt .conf file'iukas
# # odi automatinio patikrinimo/kaupimo sistema susieta su http://doneaitis.vdu.lt resursais
# # yra mini, sumanym..
# #
# #
#             api ati
#             ap  at   i nu pa par per pra pri su u
# be nieko     a   b  c  d  e  f  g   h   i   j   k  l
# su sangra  m   n  o	 p  q  r  s   t   u   v   w  x
$SIG{INT} = \&sub_exit;  
$SIG{TERM} = \&sub_exit;
$SIG{KILL} = \&sub_exit;

%prefix = (
	   c => '',     d => 'i',	e => 'nu',
	   f => 'pa',    g => 'par',    h => 'per',
	   i => 'pra',	 j => 'pri',	k => 'su',
	   l => 'u',	 m => 'apsi',	n => 'atsi',
	   o => 'si',	 p => 'isi',	q => 'nusi',
	   r => 'pasi',	 s => 'parsi',	t => 'persi',
	   u => 'prasi', v => 'prisi',	w => 'susi',
	   x => 'usi'
);
# filename hash
%fn_h = (
	 1 => 'lietuviu.daiktavardziai', 2 => 'lietuviu.vardai', 
	 3 => 'lietuviu.veiksmazodziai', 4 => 'lietuviu.budvardziai', 
	 5 => 'lietuviu.nekaitomi', 6 => 'lietuviu.ivairus', 
	 7 => 'lietuviu.jargon'
);
# file handle hash
%fh_h = (
	 1 => 'DAIKT', 2 => 'VARDAI', 
	 3 => 'VEIKS', 4 => 'BUDV',
	 5 => 'NEKAIT', 6 => 'IVAIR', 
	 7 => 'JARGON'
);

$versija = "spell.pl 0.5.0, para Laimonas Vbra <l.v\@centras.lt>, 2002, Vilnius.";
# Escape sekos spalvotam raymui
$G="\e[1;33m"; # geltona
#$Z="\e[1;32m"; # alia
$R="\e[1;31m"; # raudona
#$M="\e[0;34m"; # mlyna
$B="\e[1;37m"; # balta
$Y="\e[1;36m"; # ydra
#$V="\e[0;35m"; # violetin
$d="\e[0;39m";  # pagrindin(default)

#  @bkl_veiks_daikt_pries
#Btojo kartinio laiko(bkl) form aknies bals daniausiai(su retomis iimtimis) turi i priesag veiksmaodiniai daiktavardiai
#gyn-(imas) (: gyn) , myn-(ikas) (: myn), ...
@bkl_veiks_daikt_pries=('imas','ikas','jas','ja','yba','ykla','inys','iklis', 'oklis', 'nas','n', 'lis','l', 'ena', 'sis');

# @veiks_bendr_daikt_pries
# Bendraties akn turi i priesag daiktavardiai
# -tuvas, -tuv : vytuvas( :vyti), trintuvas (:trinti), durtuvas (: durti)
@veiks_bendr_daikt_pries=('tuvas','tuv','tukas','tis','tas','tyn','klas','kl','klys');

local $found_u = 0; # ar odis buvo rastas vartotojo ( (u)ser ) odyne
local $found_i = 0; # ar odis buvo rastas pagrindiniame, ispell'o ( (i)spell ) odyne
local $flags;
local ($opt_b, $opt_B,  # force  black & white
       $opt_v, $opt_V,  # print version
       $opt_h, $opt_H,  # print usage(--help)
       $opt_p, $opt_P,  # PATH (jei odynai yra ne /~ direktorijoje)
       $opt_f, $opt_F   # Tekstinis odi failas
);


# Komandins eiluts argument tikrinimas
use Getopt::Std;

if( !getopts('bBvVhHp:P:f:F:') || @ARGV ) { 
    print "vyko klaida - neteisingai nurodyti argumentai.\nPerirkite ar programa buvo ikviesta teisingai?\n";
    exit;
}
else {
    if ($opt_b || $opt_B) {
	# Force Black & White. Sutinku, kad spalvos gali rti ak ar kyrti. TODO: custom colors
	$d = $Y = $R = $G = $B = '';
    }
    if($opt_v || $opt_V) { 
	print "$versija\n"; 
	exit;
    }
    if($opt_h || $opt_H) {
	&usage();
	exit;
    }
    
}

$pskirt = "$B"."====================$d\n"; # odio vedimo (p)abaigos skiriamoji eilut

&atidaryti_zodynus();

print "\n-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-\n";
print "Programa, nustatanti nauj odi afiksus ir raanti odius  odynus. \n";
print "Vliau i i odyn yra kompiliuojamas lietuvi kalbos $G"."ispell$d odynas.\n";
print "    -$B Ctrl+D$d bet kada grta  programos pradi.\n";
print "    -$B Ctrl+C$d bet kada nutraukia programos vykdym.\n";
print "-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-\n";

$ARGV = '-'; # iankstinis nustatymas  STDIN

if($opt_f || $opt_F) { 
    $_ = defined($opt_f) ? $opt_f : $opt_F; 
    if(-e && -T) { $ARGV = $_; }
    else {
	print "$R"."Klaida$d, nra tokio failo: $B$_$d, arba jis nra tekstinis.\nBlogas programos rakto -(f|F) argumentas.\n"; 
	print "Nagrinsiu js vedamus odius..\n";
    }
}

$KLAUSTI = $ARGV eq '-';
open (BYLA, $ARGV) or warn "Negaliu atidaryti $ARGV: $!\n";

# Pradedam..
&main();

sub main() {
    my $msg;
    my $main_msg = "\nveskite od ($G\^D$B baigti$d\, $G"."?$B pagalba$d\): $B";
    print  $main_msg if $KLAUSTI;
    
    while ($word = <BYLA>) {{
	if ($word =~ /^[\s\#]+/) { next; } 
	elsif($word =~ /.\/./) { # komentarai, tuios eiluts bei odiai su flag'ais
	    chomp($word);
	    print "$word - jau turi afiksus.\n";
	    next;
	}

	chomp $word;
	print "$B$word$d\n";
	print "$d";
	if (!legal ($word)) { next; }  
	$flags = '';
	
	if ($word =~ /\?/) { pagalba(); next; }
	elsif ($word =~ /q/i) { sub_exit(); }
	
	$msg = "Tai $G"."d$d"."aiktavardis, $G"."v$d"."eiksmaodis, $G"."b$d"."dvardis,\n$G"."n$d"."ekaitomas odis ar $G"."j$d"."argon? ($G"."d$d\/$G"."v$d\/$G"."b$d\/$G"."n$d\/$G"."j$d)";
	do  {
	    if(!ivesti_zodi($msg, 'j')) { next; }
	} until (/^[bdnvjq\?]$/i);
	
	if    (/v/i) { veiksmazodis($word); }
	elsif (/d/i) { daiktavardis($word); }
	elsif (/b/i) { budvardis($word); }
	elsif (/n/i) { nekaitomas($word); }
	elsif (/j/i) { jargon($word); }
	if(($found_u || $found_i) && $ARGV ne '-') { print "Nordami tsti paspauskite $B\"Enter\"$d klavi..."; $_ = <STDIN>; }
    
    }
    print $main_msg if $KLAUSTI;
    }
}  

sub veiksmazodis {
    my ($bend, $es, $but);
    my ($msg, $ats);
    my $p_found_i = 0; #partial found - pagr. odyne rasta viena ar kelios aknins veiksmaodio formos 

    print "$Y"."=== Veiksmaodis ===\n$B$word$d\n";
    $msg = "veskite veiksmaodio bendrat($G"."k daryti$d\/$G"."veikti?$d\)";
    do {
	if(! ($bend = ivesti_zodi($msg, ($word =~/.*tis?$/i) ? $word : '' )) ) { return; }
	elsif(!($bend =~ /.*tis?$/i)) { print "\n$R"."Dmesio$d\, veiksmaodio bendratis turi baigtis galne \'$G"."-ti(s)$d\' !\n"; }
    }until ($bend =~/.*tis?$/i);
    
    $msg =  "veskite veiksmaodio esamj laik($G"."k daro$d\/$G"."veikia?$d\)";
    if(! ($es = ivesti_zodi($msg, ($word =~/.*(a|[^t]i)$/i) ? $word : '' )) ) { return; };
    
    $msg = "veskite veiksmaodio btj kartin laik ($G"."k dar$d\/$G"."veik?$d\)";
    if(! ($but = ivesti_zodi($msg, ($word =~/.*$/i) ? $word : '')) ) { return; } 

    my %v_h = (1 => $bend, 2 => $es, 3 => $but); # pagrindini (v)eiksmaodio form (h)ash
    my %vr_h = (1 => 0, 2 => 0, 3 => 0); # (v)eiksmaodio forma (r)asta hash
    
    foreach $i (1,2,3) {
	&paieska_zodynuose($v_h{$i}, 2);  
	if($found_i || $found_u) { $p_found_i=1; $vr_h{$i} = 1; }
    }
    if($p_found_i) {
	if($vr_h{1} && $vr_h{2} && $vr_h{3}) { return; } 
	else {
	    print "\n\nJs vest veiksmaodi:\n";
	    foreach $i (1,2,3) { 
		if(!$vr_h{$i}) {  print "$B$v_h{$i}$d\n"; }
	    }
	    print "$R"."nra$d pagrindiniame ispell odyne.\n\n";
	    print "Labai tiktina, kad ie, js vesti, veiksmaodiai yra neteisingi, o\npagrindiniame odyne yra saugomos teisingos veiksmaodio formos(bendratis,\nesamasis bei btasis kartinis laikai).\n\n";
	    print "$B"."Kitavertus$d - neatmetama galimyb, kad pagrindiniame ispell odyne yra klaida.\n";
	    print "Jei manote, kad tai yra odyno klaida -  bkite malons, $B"."pranekite$d\napie tai odyno bazs koordinatoriui.\n";
	    return;
	}	
    }
    elsif($found_u) {
	# TODO :
	return;
    }
    if(!veiks_tikrinimas(\$bend, \$es, \$but)) { return; }
    foreach $i (keys (%prefix), 'a[pt]', 'a[pt]i') {
        $prefix = ($i =~ /^a\[/) ? $i : $prefix{$i};
        next unless ($bend =~ /^$prefix(.*)/); 
        local $sb = $1;
        next unless ($es =~ /^$prefix(.*)/); 
        local $se = $1;
        next unless ($but =~ /^$prefix(.*)/); 
        local $su = $1;
	$msg = "$R"."Dmesio$d\, gali bti, kad js vestas veiksmaodis turi trumpesn(be priedli)\npamatin form)\nAr teisinga: $sb, $se, $su?";
	$ats = taip_ne ($msg, "t");
	if(!$ats) {  return; }
	elsif($ats == 1) {   
	    print "Toliau nagrinsim veiksmaodius: $sb, $se, $su\n";
	    $bend = $sb; $es = $se; $but = $su;
	    return;
	}
    }
    if (!append_flags("${bend}s, ${es}si, ${but}si?", 't', 'SX', 'NX')) { return; }
    
    $pref = ($bend =~ /^[bp]/i) ? 'api' : 'ap';
    if (!append_flags("$pref$bend, $pref$es, $pref$but?", 't', 'a')) { return; }
    
    $pref = ($bend =~ /^[dt]/i) ? 'ati' : 'at';
    if (!append_flags("$pref$bend, $pref$es, $pref$but?", 't', 'b')) {  return; }
    
    foreach $i (sort keys %prefix) {
        $pref = $prefix{$i};
        if (!append_flags("$pref$bend, $pref$es, $pref$but?", 't', "$i")) {  return; }
    }

    if ($bend =~ /[y]ti$/i and  $es =~ /[y].a$/i and $but =~ /[ui].o$/i) {
        $bf = "U";
    } else {
        $bf = "T";
    }

    $word = "$bend/$bf$flags\n";
    $word .= "$es/E$flags\n";
    if ($bend =~ /yti$/i){
	$word .= "but/Y$flags\n";
    } else {
	$word .= "$but/P$flags\n";
    }
    if ($flags =~ /S/) {
        $word .= "${bend}s/$bf\n";
        $word .= "${es}si/E\n";
        if ($bend =~ /yti$/i){
            $word .= "${but}si/Y";
        } else {
    	    $word .= "${but}si/P";
        }
    }
    print $pskirt;
    print "$word\n";
    irasyti_izodyna(2, $word);
    
}  # veiksmaodio pabaiga

sub daiktavardis() {
    my $word = shift;
    my $msg;
    my $ats;
    print "\n=== $Y"."Daiktavardis$d ===\n$B$word$d\n";
    $msg = "veskite vardininko laipsn ($G"."kas?$d\)";
    do {
	if (! ($word = ivesti_zodi($msg, $word)) ) { return; }
    	elsif($word =~ /.*[^aios]$/i) { print "\n$R"."Dmesio$d\, daiktavardio vardininko laipsnis turi baigtis raidmis \'$G"."a,,i,o,s$d\' !\n"; }
    } until( $word =~ /.*[aios]$/i );    

    &paieska_zodynuose($word, 1);
    if($found_i) { return; }
    elsif($found_u)  { return; }  # TODO 

    # Patikrinimas ar teisingai raomi veiksmaodini daiktavardi aknies balsiai #
    my $pries_id = 0;
    foreach (@bkl_veiks_daikt_pries) {
	if ($word =~ /.*$_$/i) { 
	    $pries_id = 1;
	    last;
	}
    }
    foreach (@veiks_bendr_daikt_pries) {
	if ($word =~ /.*$_$/i) { 
	    $pries_id = 2;
	    last;
	}
    }
    if ($pries_id && !daikt_teisingas_balsis($word, $pries_id)) {  return; }
    ##
		
    if ($word !~ /(.*)(is|uo)$/i) {
        $flags = 'D'
    } else {
        my ($sak, $gal) = ($1, $2);
	$sak =~ s/t$//;
    	$sak =~ s/d$/d/;
	$ats = taip_ne('Ar odis yra vyrikos gimins?', 't');
	if(!$ats) {  return; }
       	if ($gal =~ /is/i && $ats == 1) {
	    # panau, kad visi vyrikos gim. daiktavardiai su galne *.is  vns. kilmininko laipsnyje turi galun *.io, todl klausimas(r. emiau) yra nereikalingas
	    # taip_ne ("Ar vienaskaitos kilmininko($G"."ko?$d\) linksnis yra \'$B${sak}io$d\'\?", "t")) {
	    $flags = 'D'
    	} else {
            $flags = ($ats == 1) ? 'V' : 'M';
            $msg = "Ar galn minkta - daugiskaitos kilminiko($G"."ko?$d\) laipsnis yra \'$B${sak}i$d\'?";
	    if (!append_flags($msg, 't', 'I', 'K')) {  return; }
    	}
    }
    if(!append_flags("Ar yra toks daiktas ne$word?", 'n', 'N')) {  return; }
    $word = "$word/$flags";
    print $pskirt;
    print "$word\n";
    irasyti_izodyna(1, $word);
}  # daiktavardio pabaiga

sub budvardis {
    my ($kokyb, $ivardz);
    my $msg;
    my $ats;

    $word = $_[0];
    print "\n==== $Y"." Bdvardis$d =====\n$B$word$d\n";
    $msg = "veskite vardininko laipsn ($G"."kas?$d\)";  
    do {
	if (! ($word = ivesti_zodi($msg, $word)) ) {  return; }
	if($word =~ /.*[^s]$/i) { print "\n$R"."Dmesio$d\, bdvardio vardininko laipsnis turi baigtis raide \'$G"."s$d\' !\n"; }
    } until( $word =~ /.*s$/i );    

    &paieska_zodynuose($word, 3);
    if($found_i) { return; }
    elsif ($found_u) { return; } # TODO

    $word =~ /(.*)(.)s$/i;
    $kokyb = $2 ne 'i';
    $msg = "Ar tai kokybinis bdvardis (kaip $1$2; ${word}is; turi laipsnius?)";
    if (! ($ats = append_flags($msg, 't', 'AQ')) ) {  return; }
    elsif($ats == 2) {
        my ($sak, $gal) = ($1, $2);
        $sak =~ s/t$//;
	$sak =~ s/d$/d/;
        if(!append_flags("Ar tai santykinis bdvardis (kokiems - ${sak}iams)?", 't', 'B', 'A')) {  return; } 
    }
    # Albertas silo visiems bdvardiams klijuoti /N
    #if(!append_flags("Ar gali bti ne$word?", 'n', 'N')) {  return; }
    $flags .= "N";
    $word = "$word/$flags";
    print $pskirt;
    print  "$word\n";
    irasyti_izodyna(3, "$word");
}  # bdvardio pabaiga


sub nekaitomas {

    $word = $_[0];
    print "\n==== $Y"." Nekaitomas$d =====\n$B$word$d\n";
    &paieska_zodynuose($word, 4);
    if($found_i) { return; }
    elsif ($found_u) { return; } # TODO
    irasyti_izodyna(4, "$word");
}  # nekaitomas pabaiga

sub jargon {
    my $word = shift;
      
    print "\n=== $Y"."argonas$d ===\n$B$word$d\n";
    &paieska_zodynuose($word, 5);
    print "Jei tai kaitomas odis, nurodykite afiks ($G"."D,B,A...$d\): ";
    print "$B";
    $_ = <STDIN>;
    print "$d";
    chomp($_);
    if($_ ne '') { $word .= "\/$_"; } 
    irasyti_izodyna(5, "$word");
} # jargon pabaiga


sub legal {
    # Funkcija, kuri tikrina vedam odi "legalum". Mano manymu, tai iek tiek padeda ivengti klaid ir sutaupyti laiko(pvz: vlai pastebjus, kad klaidingai 
    # vestas odis, reikia i naujo pradti procedr). 
    # Kitavertus, mano "uprogramuotas legalumas" (besikartojantys, sulip priebalsiai(pvz.: ' kk','' ir t.t.), daugiau kaip trys  priebalsiai esantys greta
    # (pvz. : '.*ndk.*'), gali bti klaidingas. Jei pastebsite klaidas - pranekite <l.v@centras.lt>

    if ($word =~/^[^?q]$|.*([b,c,,d,f-h,j-n,p-t,,v,z,,,,,,,])\1+.*|.*[0-9]+.*|.*[wxq].+|.*[b,c,,d,f-h,j-n,p-t,,v,z,]{4,}.*/) {
	print	"\n$R"."Dmesio$d, labai tiktina, kad js vedte blog od(jame negali bti skaii,\n\"sulipusi\"(esani greta) priebalsi bei kai kuri balsi, lotyn abcls\nraidi [q,w,x]..ir kt.)!\n";
	return 0;
    }
    else { return 1; }
}
## main() pabaiga ##
print "$d\nIki!\n";


sub daikt_teisingas_balsis($) {
    my $word = shift;
    my $id = shift;
    my $msg;
    if ($id == 1) {
	print "\n\n$R"."Dmesio$d - tiktina, kad odis$B $word$d yra veiksmaodinis daiktavardis.\n"; 
	print "Tokie daiktavardiai yra kil i veiksmaodio(pvz. vytukas <- "; 
	print "vyti;\nirklas <- irti) ir savo aknyje daniausiai turi toki pat bals\n";
	print "kaip ir pamatinio veiksmaodio bendraties forma.\n\n";
	print "$Y"."Pvz:\n";
	print "\t$B\-tuvas:$d v$G"."y$d"."tuvas (: v$G"."y$d"."ti); tr$G"."i$d"."ntuvas (: tr$G"."i$d"."nti); d$G"."u$d"."rtuvas (: d$G"."u$d"."rti)...\n";
	print "\t$B\-tas:$d b$G"."u$d"."rtas (: b$G"."u$d"."rti); k$G"."e$d"."ltas (: k$G"."e$d"."lti); sv$G"."e$d"."rtas (: sv$G"."e$d"."rti)...\n";
	print "\t$B\-kl:$d b$G"."$d"."kl (: b$G"."$d"."ti); $G"."$d"."kl (: $G"."$d"."ti); v$G"."i$d"."rykl (: v$G"."i$d"."rti)...\n\n";
    }
    elsif ($id == 2) {
	print "\n\n$R"."Dmesio$d - tiktina, kad odis$B $word$d yra veiksmaodinis daiktavardis.\n"; 
	print "Tokie daiktavardiai yra kil i veiksmaodio(pvz. veikjas <- "; 
	print "veikia,veik;\nrainys <- rao,ra) ir savo aknyje daniausiai turi toki pat bals\n";
	print "kaip ir pamatinio veiksmaodio btojo kartinio laiko forma.\n\n";
	print "$Y"."Pvz:\n";
	print "\t$B\-imas:$d g$G"."y$d"."nimas (: g$G"."y$d"."n); r$G"."i$d"."jimas (: r$G"."i$d"."jo); k$G"."$d"."limas (: k$G"."$d"."l)...\n";
	print "\t$B\-inys:$d k$G"."$d"."rinys (: k$G"."$d"."r); n$G"."$d"."rinys (: n$G"."$d"."r); si$G"."u$d"."vinys (: si$G"."u$d"."vo)...\n";
	print "\t$B\-sis:$d gri$G"."u$d"."vsis (: gri$G"."u$d"."vo); di$G"."$d"."vsis (: di$G"."$d"."vo); p$G"."u$d"."vsis (: p$G"."u$d"."vo)...\n\n";
    }
    $msg = "Pasitikrinkite ar daiktavardio aknyje yra teisingas balsis?";
    if ( !taip_ne($msg, "t")) {
	$msg = "veskite teising od ($G"."q$d sugrti  pradi)";
	if (! ($word = ivesti_zodi($msg, $word)) ) {  return; };
    }
    return 1;
}

sub atidaryti_zodynus()
{
    use Fcntl qw(:DEFAULT :flock);
    my $home; 
    if($opt_p || $opt_P){
       	$_ = defined($opt_p) ? $opt_p : $opt_P;
	if(-d) {
	    if(/\/bin\/?.*|\/usr\/bin\/?.*|\/usr\/local\/bin\/?.*|\/sbin\/?.*|\/usr\/sbin\/?.*|\/usr\/X11R6\/?.*/) {
		print "$R"."Bt neprotinga$d saugoti odyn failus $B$_$d direktorijoje.\n";
		print "Jei js manote kitaip - fixme($0, ".(__LINE__ - 2)." eilut)\n";
		print "Usispyriau, toliau neveiksiu! ;)\n";
		exit;
	    }
	    else { $home = $_; }
	}
	else { print "$R"."Klaida$d, nra tokios direktorijos: $B$_$d !\nBlogas programos rakto -(p|P) argumentas.\n"; exit; }
    }
    else{ $home = $ENV{"HOME"} || $ENV{"LOGDIR"} || (getpwuid($<))[7]; }
           
    foreach $key ( keys (%fn_h) ) {
	sysopen( $fh_h{$key},"$home/$fn_h{$key}", O_RDWR | O_APPEND |O_CREAT) or die "\$n$R"."Dmesio$d\, negaliu atidaryti/sukurti /$home/$fn_h{$key} !";
	flock($fh_h{$key}, LOCK_EX) or die "\n$R"."Dmesio$d\, negaliu urakinti(lock) /$home/$fn_h{$key} !";    
    }

}
sub paieska_zodynuose($$) {
    my $word = shift;
    my $dalis_id = shift; # kokia kalbos dalis 1 - daiktavardis, 2 - veiksmaodis, 3 - bdvardis, 4 - nekaitoma
    my ($str1, $msg, $ats);
    my $af = '';
    $found_i = 0;
    # paieka pagrindiniame ispell odyne #
    open(FROM_ISPELL, "echo $word | ispell -d lietuviu -a | grep \'^[*,-,+,&,#,?]\' |") or die 	"\n$R"."Dmesio$d".", negaliu vykdyti komandos \'echo $word | ispell -d lietuviu -a | grep \'^[*,-,+,&,#,?]\' \' !";
    $_ = <FROM_ISPELL>;
    close(FROM_ISPELL);
    if (/^\*/) {
	print "$R"."Dmesio$d".", odis $B\'$word\'$d yra pagrindiniame ispell odyne.\n";
	$found_i = 1;
	return;
    }
    elsif ( /^\+.(.*)$/ ) {
	print "$R"."Dmesio$d".", js vesta odio forma $B\'$word\'$d turi aknin od $G\'$1\'$d,\nkuris  yra pagrindiniame ispell odyne.\n";
	$found_i = 1;
	return;
    }
    ##	   
    
    # TODO: tikrinti abu odynus(tiek sukompiliuot, tiek vartotojo) ir iekoti galimai pasikartojani odi
    if ($dalis_id == 1) {
    # daiktavardio paieka ~ direktorijoje esaniuose odynuose #
	foreach $key (1,2) {
	    if(find_in($fh_h{$key}, $word)) {
		$str1 = $fn_h{$key};
		$af = $_;
		last;
	    }
	}
    }##
    elsif($dalis_id == 2) {
    # veiksmaodio paieka ~ direktorijoje esaniuose odynuose #
	if(find_in($fh_h{3}, $word)) {
	    $str1 = $fn_h{3};
	    $af = $_;
	    last;
	}
    }##
    elsif($dalis_id == 3) {
    # bdvardio paieka ~ direktorijoje esaniuose odynuose #
	if(find_in($fh_h{4}, $word)) {
	    $str1 = $fn_h{4};
	    $af = $_;
	    last;
	}
    }##
    elsif($dalis_id == 4) {
    # nekaitomo odio paieka ~ direktorijoje esaniuose odynuose #
	foreach $key (5,6) {
	    if(find_in($fh_h{$key}, $word)) {
		$str1 = $fn_h{$key};
		last;
	    }
	}
    }##
    elsif($dalis_id == 5) {
    # jargon paieka ~ direktorijoje esaniuose odynuose #
	if(find_in($fh_h{7}, $word)) {
	    $str1 = $fn_h{7};
	    last;
	}
    }##
    if ($found_u) { print "\n$R"."Dmesio$d".", odis $B$word$Y\/$af$d yra odyne \'$str1\'.";  }
}  

sub taip_ne($$) {
    my $msg = shift;
    my $def_ans = shift;
    my $kart = 0;
    do {
	if ($kart > 3) { 
	    print "\n$d"."veskite ($G"."t$d,$G"."n$d arba $G"."q$d): $B"; 
	}
	else { print "$msg ($G"."t$d\/$G"."n$d\) [$B"."$def_ans$d\]: $B"; }
    	$_ = <STDIN>;
	print "$d";
	if (!defined || /q/i) {  return; }
	chomp($_);
	$_ = $def_ans if $_ eq '';
	$kart++;
    } until /^[tnq]$/i;
    return (/t/i) ? 1 : 2;
}

sub ivesti_zodi($;$) {
    my $msg = shift;
    my $def_word = shift ;
    my $kart = 0;
    do {
	if($kart >= 3) { print "\nveskite teising od ($G"."q$d sugrti  pradi): $B"; } 
	else { 
	    if( defined($def_word) && $def_word ne '' ) { print "$msg [$B$def_word$d\]: $B"; }
	    else { print "$msg: $B"; }
	} 
	$_ = <STDIN>;
	print "$d";
	if (!defined || /q/i) {  return; }
	chomp ($_);
	if( $_ eq '' && defined($def_word) ) { $_ = $def_word; }
    } until (legal ($_) );
    return $_;
}

sub sub_exit {
    print "$d";
    exit;
}

sub irasyti_izodyna ($$) {
    my $id = shift;
    my $word = shift;
    my $idx;
    
    if ($id == 1) { $idx = 1; }
    elsif ($id == 2) { $idx = 3; }
    elsif ($id == 3) { $idx = 4; }
    elsif ($id == 4) { $idx = 5; }  
    elsif ($id == 5) { $idx = 7; }  
   
    write_to($fh_h{$idx}, $word);

}

sub write_to($$)
{
    my $FH = shift;
    my $word = shift;

    seek($FH, 0, 2) or die "$R"."Dmesio$d\, negaliu pereiti  failo gal.\n";
    print $FH "$word\n" or die "$R"."Dmesio$d\, negaliu rayti  failo gal.\n";
    print "rayta\n";
}

sub find_in($$)
{
    my $FH = shift;
    my $word = shift;
    $found_u = 0;
    
    if (tell($FH)) { seek($FH, 0, 0) or die "$R"."Dmesio$d\, negaliu pereiti  failo pradi.\n"; }
    while ( <$FH> ) {
	if (/^$word(\/(.+))?$/i) {
	    $found_u = 1;
	    $_ = $2;
	    last;
	}
    }
    if ($found_u) {  return ($_) ? $_ : 1; }
}

sub append_flags($$$;$) {
    my $msg = shift;
    my $def = shift;
    my $f_true = shift;
    my $f_false = shift;
    my $ats = taip_ne($msg, $def);
    if(!$ats) { return; }
    elsif($ats == 1) { $flags .= $f_true; }
    elsif($ats == 2 && defined($f_false)) { $flags .= $f_false; }
    return $ats;
}

sub veiks_tikrinimas (\$\$\$) {
    my $bend = shift;
    my $es = shift;
    my $but = shift;
    my ($msg, $ats);
    
    # Patikrinimas ar teisingai ramos nosins balss veiksmaodi aknyse prie raid 's'
    if ( $$bend =~ /^(.*)(.)([aeiyu])(s.*)$/i || $es =~ /^(.*)(.)([aeiyu])(s.*)$/i ) {
	my ($_1, $_2, $_3, $_4) = ($1, $2, $3, $4);
	my $itart; # tartina bendratis?(1), esamasis laikas?(0), abu?(2) 
	($$bend eq "$1$2$3$4") ? ($itart = 1) : ($itart = 0);
	if ($itart) { ($$es =~/$1$2$3s.*/i) ? ($itart = 2)  : ($itart = 1); }
	if ( $$es =~ /$1$2[aeiu]n.*/i || $$but =~ /$1$2[aeiu]n.*/i || $$bend =~ /$1$2[aeiu]n.*/i ) {
	    print "\n$R"."Dmesio$d\, nosins balss $B"."$d\,$B"."$d\,$B"."$d\,$B"."$d raomos veiksmaodi aknyse prie \'$d"."s$d\',\nkai pagrindiniuose kamienuose ios balss kaitaliojasi su $G"."an$d\,$G"."en$d\,$G"."in$d\,$G"."un$d.\n$Y"."Pvz:$d\n\tgr$B\$d\(s)ti : gr$G"."in$d"."dia, gr$G"."in$d"."d; br$B"."$d\(s)ti, br$B"."$d\(s)ta : br$G"."en$d"."do...\n"; 
	    $_ = $_3;
	    if( /a/i ) { $_ = ''; }
	    elsif( /e/i ) { $_ = ''; }
	    elsif( /[u]/i ) { $_ = ''; }
	    elsif( /[iy]/i ) { $_ = ''; }
	    my ($str1, $str2, $es_tb, $bend_tb); # $es_tb, $bend_tb - (t)urt (b)ti
	    print "-------------------------------------------------------------------------------";
	    if ($itart == 2) {
		my $tmp = $$es;
		$tmp =~ s/$_1$_2$_3(.*)/$_1$_2$G$_3$d$1/i;
	        $str1 = "\'$_1$_2$G$_3$d$_4\', \'$tmp\'";
		$tmp = $$es;
		$tmp =~ s/$_1$_2$_3(.*)/$_1$_2$_$1/i;
	        $es_tb = $tmp;
		$bend_tb = "$_1$_2$_$_4";
	        $tmp =~ s/^$_1$_2$_(.*)/$_1$_2$G$_$d$1/i ;
	        $str2 = "\'$_1$_2$G$_$d$_4\', \'$tmp\'";
            }
	    else { 
		$str1 = "$_1$_2$G$_3$d$_4"; 
		$str2 = "$_1$_2$G$_$d$_4"; 
		($itart == 0) ? ($es_tb = "$_1$_2$_$_4") : ($bend_tb = "$_1$_2$_$_4");  
	    }
	    do {
		print "\n$B"."Js vedte$d $str1 nors taisykl byloja, kad:\n$R"."Turt bti$d $str2.\n";
		$msg = "Ar sutinkate su taisyke?";
		if(! ($ats = taip_ne($msg, 't')) ) {  return; }
		elsif($ats == 2) {
		    $msg = "Neregtas usispyrimas.. :). Belieka paklausti ar esate sitikin, kad odius\nvedte teisingai?\n$$bend, $$es, $$but?";
		    if(! ($ats = taip_ne($msg, "n")) ) {  return; }
		
		}
		else { 
		    if($es_tb) { $$es = $es_tb; } 
		    if ($bend_tb) { $$bend = $bend_tb; }
		    print "\n$$bend, $$es, $$but\n";
		}
	    } while ($ats == 2);
	}
    }
    return 1;
}

sub pagalba() {
    system('clear');
    print "Programos veikimo $G"."principas$d\:\n";
    print "odi kaupimas yra iskirtas  5 pagrindinius skyrius, tai yra:\n";
    print "    -$B Daiktavardis$d\n";
    print "    -$B Veiksmaodis$d\n";
    print "    -$B Bdvardis$d\n";
    print "    -$B Nekaitoma$d\n";
    print "    -$B Jargon$d\n";
    print "    vedus od bei pasirinkus skyri, programa paprays vesti aknin odio\n";
    print "form(daiktavardiams, bdvardiams  - vardininko laipsnis, veiksmaodiams tai\n";
    print "yra bendratis, esamasis bei btasis kartinis laikai). Svoka \"akninis odis\"\n";
    print "reikia, kad is odis kartu su nustatytais afiks parametrais(vliavls) bus\n";
    print "isaugotas odyne.\n";
    print "    Toliau programa ieko js vesto akninio od-io(i) pagrindiniame bei \n";
    print "-(p|P) raktu nurodytoje arba nam direktorijoje(/~) esaniuose odynuose.\n";
    print "    Jei odis i tikrj neinomas, programa kaip manoma draugikiau paprays\n";
    print "suteikti jai paildom informacij(odio linksniai, laikai, priedliai,\n";
    print "galns, kita) kuri reikalinga teisingiems odio afiksams nustatyti. Po vis\n"; 
    print "i veiksm, jums sutikus, odis bus raytas  atitinkam odyn.\n\n";
    print "    -$B Ctrl+D$d - bet kada grta  programos pradi. Esant programos pradioje\n";
    print "i kombinacija nutraukia jos vykdym.\n";
    print "    -$B Ctrl+C$d - bet kada nutraukia programos vykdym.\n";
}

sub usage()
{
print "$versija\n";
print "\nProgramos argumentai:\n\n";
print "-b, -B\tNenaudoti spalv(prastas, bespalvis tekstas)\n";
print "-f, -F\tFailas i kurio bus skaitomi ir nagrinjami odiai.\n\tNutyljus(nenurodius -f ar -F) bus skaitomi ir nagrinjami vartotojo\n\tvedami odiai\n";
print "-h, -H\tPagalba(is programos argument sraas)\n";
print "-p, -P\tDirektorija, kurioje saugomi odyno failai.\n\tNutyljus(nenurodius -p ar -P) tai yra vartotojo nam direktorija /~\n";

}
