/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif

gdouble GnomeCanvas_get_scroll_x1 (GnomeCanvas * cptr) 
{
    return cptr->scroll_x1;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    getScrollX1
 * Signature: (I)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_Canvas_getScrollX1 (JNIEnv *env, jclass cls, jint 
    cptr) 
{
    GnomeCanvas *cptr_g = (GnomeCanvas *)cptr;
    {
        jdouble result_j = (jdouble) (GnomeCanvas_get_scroll_x1 (cptr_g));
        return result_j;
    }
}

gdouble GnomeCanvas_get_scroll_y1 (GnomeCanvas * cptr) 
{
    return cptr->scroll_y1;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    getScrollY1
 * Signature: (I)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_Canvas_getScrollY1 (JNIEnv *env, jclass cls, jint 
    cptr) 
{
    GnomeCanvas *cptr_g = (GnomeCanvas *)cptr;
    {
        jdouble result_j = (jdouble) (GnomeCanvas_get_scroll_y1 (cptr_g));
        return result_j;
    }
}

gdouble GnomeCanvas_get_scroll_x2 (GnomeCanvas * cptr) 
{
    return cptr->scroll_x2;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    getScrollX2
 * Signature: (I)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_Canvas_getScrollX2 (JNIEnv *env, jclass cls, jint 
    cptr) 
{
    GnomeCanvas *cptr_g = (GnomeCanvas *)cptr;
    {
        jdouble result_j = (jdouble) (GnomeCanvas_get_scroll_x2 (cptr_g));
        return result_j;
    }
}

gdouble GnomeCanvas_get_scroll_y2 (GnomeCanvas * cptr) 
{
    return cptr->scroll_y2;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    getScrollY2
 * Signature: (I)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_Canvas_getScrollY2 (JNIEnv *env, jclass cls, jint 
    cptr) 
{
    GnomeCanvas *cptr_g = (GnomeCanvas *)cptr;
    {
        jdouble result_j = (jdouble) (GnomeCanvas_get_scroll_y2 (cptr_g));
        return result_j;
    }
}

gdouble GnomeCanvas_get_pixels_per_unit (GnomeCanvas * cptr) 
{
    return cptr->pixels_per_unit;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    getPixelsPerUnit
 * Signature: (I)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gnome_Canvas_getPixelsPerUnit (JNIEnv *env, jclass cls, 
    jint cptr) 
{
    GnomeCanvas *cptr_g = (GnomeCanvas *)cptr;
    {
        jdouble result_j = (jdouble) (GnomeCanvas_get_pixels_per_unit (cptr_g));
        return result_j;
    }
}

GnomeCanvasItem * GnomeCanvas_get_current_item (GnomeCanvas * cptr) 
{
    return cptr->current_item;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    getCurrentItem
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_getCurrentItem (JNIEnv *env, jclass cls, jint 
    cptr) 
{
    GnomeCanvas *cptr_g = (GnomeCanvas *)cptr;
    {
        return (jint)GnomeCanvas_get_current_item (cptr_g);
    }
}

GnomeCanvasItem * GnomeCanvas_get_focused_item (GnomeCanvas * cptr) 
{
    return cptr->focused_item;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    getFocusedItem
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_getFocusedItem (JNIEnv *env, jclass cls, jint 
    cptr) 
{
    GnomeCanvas *cptr_g = (GnomeCanvas *)cptr;
    {
        return (jint)GnomeCanvas_get_focused_item (cptr_g);
    }
}

GnomeCanvasItem * GnomeCanvas_get_grabbed_item (GnomeCanvas * cptr) 
{
    return cptr->grabbed_item;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    getGrabbedItem
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_getGrabbedItem (JNIEnv *env, jclass cls, jint 
    cptr) 
{
    GnomeCanvas *cptr_g = (GnomeCanvas *)cptr;
    {
        return (jint)GnomeCanvas_get_grabbed_item (cptr_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1get_1type (JNIEnv *env, jclass 
    cls) 
{
    {
        return (jint)gnome_canvas_get_type ();
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1new (JNIEnv *env, jclass cls) 
{
    {
        return (jint)gnome_canvas_new ();
    }
}

/*
 * Class:     org_gnu_gnome_Canvas  
 * Method:    gnome_canvas_new_aa
 * Signature: ()I  
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1new_1aa   
(JNIEnv *env, jclass cls)
{
	return (jint)gnome_canvas_new_aa();
}
                                                                                 

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_root
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1root (JNIEnv *env, jclass cls, 
    jint canvas) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    {
        return (jint)gnome_canvas_root (canvas_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_set_scroll_region
 * Signature: (IDDDD)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1set_1scroll_1region (JNIEnv 
    *env, jclass cls, jint canvas, jdouble x1, jdouble y1, jdouble x2, jdouble y2) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    gdouble x1_g = (gdouble) x1;
    gdouble y1_g = (gdouble) y1;
    gdouble x2_g = (gdouble) x2;
    gdouble y2_g = (gdouble) y2;
    {
        gnome_canvas_set_scroll_region (canvas_g, x1_g, y1_g, x2_g, y2_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_get_scroll_region
 * Signature: (I[Ldouble ;[Ldouble ;[Ldouble ;[Ldouble ;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1get_1scroll_1region (JNIEnv 
    *env, jclass cls, jint canvas, jdoubleArray x1, jdoubleArray y1, jdoubleArray x2, 
    jdoubleArray y2) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    gdouble *x1_g = (gdouble *) (*env)->GetDoubleArrayElements (env, x1, NULL);
    gdouble *y1_g = (gdouble *) (*env)->GetDoubleArrayElements (env, y1, NULL);
    gdouble *x2_g = (gdouble *) (*env)->GetDoubleArrayElements (env, x2, NULL);
    gdouble *y2_g = (gdouble *) (*env)->GetDoubleArrayElements (env, y2, NULL);
    {
        gnome_canvas_get_scroll_region (canvas_g, x1_g, y1_g, x2_g, y2_g);
        (*env)->ReleaseDoubleArrayElements (env, x1, (jdouble *) x1_g, 0);
        (*env)->ReleaseDoubleArrayElements (env, y1, (jdouble *) y1_g, 0);
        (*env)->ReleaseDoubleArrayElements (env, x2, (jdouble *) x2_g, 0);
        (*env)->ReleaseDoubleArrayElements (env, y2, (jdouble *) y2_g, 0);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_set_pixels_per_unit
 * Signature: (ID)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1set_1pixels_1per_1unit (JNIEnv 
    *env, jclass cls, jint canvas, jdouble n) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    gdouble n_g = (gdouble) n;
    {
        gnome_canvas_set_pixels_per_unit (canvas_g, n_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_scroll_to
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1scroll_1to (JNIEnv *env, jclass 
    cls, jint canvas, jint cx, jint cy) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    gint32 cx_g = (gint32) cx;
    gint32 cy_g = (gint32) cy;
    {
        gnome_canvas_scroll_to (canvas_g, cx_g, cy_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_get_scroll_offsets
 * Signature: (I[Lint ;[Lint ;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1get_1scroll_1offsets (JNIEnv 
    *env, jclass cls, jint canvas, jintArray cx, jintArray cy) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    gint *cx_g = (gint *) (*env)->GetIntArrayElements (env, cx, NULL);
    gint *cy_g = (gint *) (*env)->GetIntArrayElements (env, cy, NULL);
    {
        gnome_canvas_get_scroll_offsets (canvas_g, cx_g, cy_g);
        (*env)->ReleaseIntArrayElements (env, cx, (jint *) cx_g, 0);
        (*env)->ReleaseIntArrayElements (env, cy, (jint *) cy_g, 0);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_update_now
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1update_1now (JNIEnv *env, 
    jclass cls, jint canvas) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    {
        gnome_canvas_update_now (canvas_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_get_item_at
 * Signature: (IDD)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1get_1item_1at (JNIEnv *env, 
    jclass cls, jint canvas, jdouble x, jdouble y) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    gdouble x_g = (gdouble) x;
    gdouble y_g = (gdouble) y;
    {
        return (jint)gnome_canvas_get_item_at (canvas_g, x_g, y_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_get_color
 * Signature: (Ijava.lang.String;[Lint ;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1get_1color (JNIEnv *env, 
    jclass cls, jint canvas, jstring spec, jintArray color) 
{
    const gchar* spec_g = (*env)->GetStringUTFChars(env, spec, 0);
    gint *color_g_g = (gint *) (*env)->GetIntArrayElements (env, color, NULL);
    GdkColor *color_g = (GdkColor *)color_g_g;
    jboolean result_j = (jboolean) (gnome_canvas_get_color ((GnomeCanvas*)canvas, spec_g, color_g));
    (*env)->ReleaseIntArrayElements (env, color, (jint*)color_g_g, 0);
    (*env)->ReleaseStringUTFChars(env, spec, spec_g);
    return result_j;
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_get_color_pixel
 * Signature: (II)J
 */
JNIEXPORT jlong JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1get_1color_1pixel (JNIEnv 
    *env, jclass cls, jint canvas, jint rgba) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    gint32 rgba_g = (gint32) rgba;
    {
        jlong result_j = (jlong) (gnome_canvas_get_color_pixel (canvas_g, rgba_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_set_stipple_origin
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1set_1stipple_1origin (JNIEnv 
    *env, jclass cls, jint canvas, jint gc) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    GdkGC *gc_g = (GdkGC *)gc;
    {
        gnome_canvas_set_stipple_origin (canvas_g, gc_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_set_dither
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1set_1dither (JNIEnv *env, 
    jclass cls, jint canvas, jint dither) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    GdkRgbDither dither_g = (GdkRgbDither) dither;
    {
        gnome_canvas_set_dither (canvas_g, dither_g);
    }
}

/*
 * Class:     org.gnu.gnome.Canvas
 * Method:    gnome_canvas_get_dither
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1get_1dither (JNIEnv *env, 
    jclass cls, jint canvas) 
{
    GnomeCanvas *canvas_g = (GnomeCanvas *)canvas;
    {
        jint result_j = (jint) (gnome_canvas_get_dither (canvas_g));
        return result_j;
    }
}

/*
 * Class:     org_gnu_gnome_Canvas
 * Method:    gnome_canvas_set_center_scroll_region
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1set_1center_1scroll_1region
  (JNIEnv *env, jclass cls, jint canvas, jboolean center)
{
	gnome_canvas_set_center_scroll_region((GnomeCanvas*)canvas, (gboolean)center);
}
                                                                                
/*
 * Class:     org_gnu_gnome_Canvas
 * Method:    gnome_canvas_get_center_scroll_region
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1get_1center_1scroll_1region
  (JNIEnv *env, jclass cls, jint canvas)
{
	return (jboolean)gnome_canvas_get_center_scroll_region((GnomeCanvas*)canvas);
}
                                                                                
/*
 * Class:     org_gnu_gnome_Canvas
 * Method:    gnome_canvas_request_redraw
 * Signature: (IIIII)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1request_1redraw 
  (JNIEnv *env, jclass cls, jint canvas, jint x1, jint y1, jint x2, jint y2)
{
	gnome_canvas_request_redraw((GnomeCanvas*)canvas, x1, y1, x2, y2);
}
                                                                                
/*
 * Class:     org_gnu_gnome_Canvas
 * Method:    gnome_canvas_window_to_world
 * Signature: (IDD[D[D)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1window_1to_1world
  (JNIEnv *env, jclass cls, jint canvas, 
  jdouble winx, jdouble winy, jdoubleArray worldx, jdoubleArray worldy)
{
	jdouble *wx = (*env)->GetDoubleArrayElements(env, worldx, NULL);
	jdouble *wy = (*env)->GetDoubleArrayElements(env, worldy, NULL);
	gnome_canvas_window_to_world((GnomeCanvas*)canvas, winx, winy, wx, wy);
	(*env)->ReleaseDoubleArrayElements(env, worldx, wx, 0);
	(*env)->ReleaseDoubleArrayElements(env, worldy, wy, 0);
}
                                                                                
/*
 * Class:     org_gnu_gnome_Canvas
 * Method:    gnome_canvas_world_to_window
 * Signature: (IDD[D[D)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_Canvas_gnome_1canvas_1world_1to_1window
  (JNIEnv *env, jclass cls, jint canvas, 
  jdouble worldx, jdouble worldy, jdoubleArray winx, jdoubleArray winy)
{
	jdouble *wx = (*env)->GetDoubleArrayElements(env, winx, NULL);
	jdouble *wy = (*env)->GetDoubleArrayElements(env, winy, NULL);
	gnome_canvas_window_to_world((GnomeCanvas*)canvas, worldx, worldy, wx, wy);
	(*env)->ReleaseDoubleArrayElements(env, winx, wx, 0);
	(*env)->ReleaseDoubleArrayElements(env, winy, wy, 0);
}
                                                                                
	
#ifdef __cplusplus
}

#endif
