package gnu.crypto.sasl;

// ----------------------------------------------------------------------------
// $Id: AuthInfoProviderFactory.java,v 1.1 2004/07/21 01:41:57 dalibor Exp $
//
// Copyright (C) 2003, Free Software Foundation, Inc.
//
// This file is part of GNU Crypto.
//
// GNU Crypto is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// GNU Crypto is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to the
//
//    Free Software Foundation Inc.,
//    59 Temple Place - Suite 330,
//    Boston, MA 02111-1307
//    USA
//
// Linking this library statically or dynamically with other modules is
// making a combined work based on this library.  Thus, the terms and
// conditions of the GNU General Public License cover the whole
// combination.
//
// As a special exception, the copyright holders of this library give
// you permission to link this library with independent modules to
// produce an executable, regardless of the license terms of these
// independent modules, and to copy and distribute the resulting
// executable under terms of your choice, provided that you also meet,
// for each linked independent module, the terms and conditions of the
// license of that module.  An independent module is a module which is
// not derived from or based on this library.  If you modify this
// library, you may extend this exception to your version of the
// library, but you are not obligated to do so.  If you do not wish to
// do so, delete this exception statement from your version.
// ----------------------------------------------------------------------------

import gnu.crypto.Registry;
import gnu.crypto.sasl.crammd5.CramMD5AuthInfoProvider;
import gnu.crypto.sasl.plain.PlainAuthInfoProvider;
import gnu.crypto.sasl.srp.SRPAuthInfoProvider;

/**
 * The concrete SASL authentication information provider factory.
 *
 * @version $Revision: 1.1 $
 */
public class AuthInfoProviderFactory implements IAuthInfoProviderFactory {

   // Constants and variables
   // -------------------------------------------------------------------------

   // Constructor(s)
   // -------------------------------------------------------------------------

   // implicit 0-args constructor

   // Class methods
   // -------------------------------------------------------------------------

   // Instance methods
   // -------------------------------------------------------------------------

   // IAuthInfoProviderFactory interface implementation -----------------------

	public IAuthInfoProvider getInstance(String mechanism) {
      if (mechanism == null) {
         return null;
      }
      mechanism = mechanism.trim().toUpperCase();
      if (mechanism.startsWith(Registry.SASL_SRP_MECHANISM)) {
         return new SRPAuthInfoProvider();
      }
      if (mechanism.equals(Registry.SASL_CRAM_MD5_MECHANISM)) {
         return new CramMD5AuthInfoProvider();
      }
      if (mechanism.equals(Registry.SASL_PLAIN_MECHANISM)) {
         return new PlainAuthInfoProvider();
      }
      return null;
   }
}
