
/*
 * Kanatest
 *
 * Copyright (C) 2001 Tomasz Mka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <gtk/gtk.h>

#include "gui.h"
#include "prefs.h"
#include "main.h"
#include "test.h"
#include "i18n.h"
#include "randomlib.h"

gchar hiragana_path[MAX_PATH];
gchar katakana_path[MAX_PATH];
gchar romaji_path[MAX_PATH];

gint q_counter, qc, qn;
gint a_counter;
gint max_entries;

gfloat tval;

gint qst_h[MAX_SIGNS];
gint ast_h[MAX_SIGNS];

gchar *jsigns[] = {	

	"a",		"i",			"u",			"e",		"o",
	"ka",		"ki",			"ku",			"ke",		"ko",
	"sa",		"shi",			"su",			"se",		"so",
	"ta",		"chi",			"tsu",			"te",		"to",
	"na",		"ni",			"nu",			"ne",		"no",
	"ha",		"hi",			"fu",			"he",		"ho",
	"ma",		"mi",			"mu",			"me",		"mo",
	"ya",						"yu",						"yo",
	"ra",		"ri",			"ru",			"re",		"ro",
	"wa",													"wo",
	"n",

	"ga",		"gi",			"gu",			"ge",		"go",
	"za",		"ji_shi",   	"zu_su",		"ze",		"zo",
	"da",		"ji_chi",		"zu_tsu",		"de",		"do",
	"ba",		"bi",			"bu",			"be",		"bo",
	"pa",		"pi",			"pu",			"pe",		"po",

	"kya",						"kyu",						"kyo",
	"sha",						"shu",						"sho",
	"cha",						"chu",						"cho",
	"nya",						"nyu",						"nyo",
	"hya",						"hyu",						"hyo",
	"mya",						"myu",						"myo",
	"rya",						"ryu",						"ryo",

	"gya",						"gyu",						"gyo",
	"ja",						"ju",						"jo",
	"bya",						"byu",						"byo",
	"pya",						"pyu",						"pyo"

};

/*--------------------------------------------------------------------*/

void test_gen_htab (gint number)
{
gint i, tmp;
gint zm, zm_s, zm_d;

	RandomInitialise((time (NULL) + getpid()) & 0x7fff, getpid () & 0x3fff);

	for (i = 0; i < number; i++) {
		qst_h[i] = i;
		ast_h[i] = 0;
	}
    
	zm = (gint)(number * 24.0 * RandomUniform());
    
	for (i = 0; i < zm; i++) {
		do {
			zm_s = (gint)(number * RandomUniform());
			zm_d = (gint)(number * RandomUniform());
		} while (zm_s == zm_d);
        
		tmp = qst_h[zm_s];
		qst_h[zm_s] = qst_h[zm_d];
		qst_h[zm_d] = tmp;
	}

}

/*--------------------------------------------------------------------*/

gchar* test_min2str (gfloat minutes)
{
static gchar obuffer[buffer_size];
guint d, h;

	d = minutes / (24 * 60);
	minutes = minutes - d * (24 * 60);
	h = minutes / 60;
	minutes = minutes - h * 60;
    
	sprintf (obuffer, _("%2d days, %2d hours, %.2f minutes"), d, h, minutes);
	return obuffer;
}

/*--------------------------------------------------------------------*/

void test_init (void)
{
struct stat sf1, sf2, sf3;
gchar path_tmp[MAX_PATH];
gint r;

	s_strcpy (hiragana_path, config.data_path, MAX_PATH);
	s_strcat (hiragana_path, hiragana_dir, MAX_PATH);

	s_strcpy (katakana_path, config.data_path, MAX_PATH);
	s_strcat (katakana_path, katakana_dir, MAX_PATH);

	s_strcpy (romaji_path, config.data_path, MAX_PATH);
	s_strcat (romaji_path, romaji_dir, MAX_PATH);

	r = 3;
	strcpy (path_tmp, hiragana_path);
	strcat (path_tmp, "zu_tsu.png");
	if (stat(path_tmp, &sf1) && !S_ISREG(sf1.st_mode)) r--;
	strcpy (path_tmp, katakana_path);
	strcat (path_tmp, "zu_tsu.png");
	if (stat(path_tmp, &sf2) && !S_ISREG(sf2.st_mode)) r--;
	strcpy (path_tmp, romaji_path);
	strcat (path_tmp, "zu_tsu.png");
	if (stat(path_tmp, &sf3) && !S_ISREG(sf3.st_mode)) r--;

	if (r != 3) {
		fprintf(stderr, "ERROR: cannot find pixmaps in %s...\n", config.data_path);
		exit(-1);
	}
}

/*--------------------------------------------------------------------*/

void test_stats (void)
{
int p;

	tval = ((difftime (time(NULL), timer_int_l)) / 60.0);
	config.t_time += tval;

	p = qn - a_counter;

	switch (test_mode) {
		case HIRAGANA:
			config.hiragana_counter++;
			if (config.hiragana_max_result < p)	config.hiragana_max_result = p;
			config.hiragana_time += tval;
			break;
		case KATAKANA:
			config.katakana_counter++;
			if (config.katakana_max_result < p)	config.katakana_max_result = p;
			config.katakana_time += tval;
			break;
		case MIXED:
			config.mixed_counter++;
			if (config.mixed_max_result < p) config.mixed_max_result = p;
			config.mixed_time += tval;
			break;
	}

}

/*--------------------------------------------------------------------*/

void test_main (gchar *text)
{
gchar answer[ANS_LEN];
gint number, i, l, b;

	number = qst_h[q_counter] % N_SIGNS;

	s_strcpy (answer, jsigns[number], ANS_LEN);
	
	for(i=0; i < ANS_LEN; i++)
		if(answer[i]=='_') answer[i]='\0';

	if (strcmp(text, answer)) {

		gtk_widget_set_sensitive (rm_entry, FALSE);
		gtk_widget_set_sensitive (stop_button, FALSE);

		gui_put_sign (qst_h[q_counter], ROMAJI);

		while (gtk_events_pending())
		    gtk_main_iteration();

		sleep (1);

		gtk_widget_set_sensitive (rm_entry, TRUE);
		gtk_widget_set_sensitive (stop_button, TRUE);

		gtk_widget_grab_focus (rm_entry);

		a_counter++;
		ast_h[q_counter] = 1;

	} else {

		if(config.repeat_wrong == TRUE) {
			qst_h[q_counter] = -1;
			ast_h[q_counter] = 0;
		}

	}

	if(config.repeat_wrong == TRUE) {

		b = 0;

        do {
			q_counter = (q_counter + 1) % max_entries;
			if(b==max_entries) break;
			b++;
		} while((qst_h[q_counter])==-1);

		qc++;

	} else 
		q_counter = (q_counter + 1) % max_entries;

	qn++;

	gui_set_progress();
	gtk_entry_set_text (GTK_ENTRY(rm_entry), "");

	if(config.repeat_wrong == FALSE) {

		/* RWA ... is disabled  :) */

		if(q_counter == 0) {

			test_stats ();
			gui_stat_create_window (test_mode);
			gui_disable_test ();

		} else
			gui_put_sign (qst_h[q_counter], test_mode);

	} else {

		/* RWA ... is enabled  :) */

		for(l=b=0;l<max_entries;l++) b+=ast_h[l];

		if(b==0 && qc >= max_entries) {

				test_stats ();
				gui_stat_create_window (test_mode);
				gui_disable_test ();

		} else
			if(qst_h[q_counter]!=-1)
				gui_put_sign (qst_h[q_counter], test_mode);

	}

}


