#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#include <qlayout.h>
#include <qvbox.h>
#include <qtooltip.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qrect.h>

#include <klocale.h>
#include <kglobal.h>
#include <kaboutdata.h>
#include <kaboutapplication.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kapplication.h>

#include "misc.h"
#include "fishes.h"
#include "canvasview.h"
#include "bubbles.h"
#include "pref.h"
#include "configdlg.h"

#include "main.h"

extern "C"
{
    KPanelApplet* init( QWidget *parent, const QString& configFile )
    {
        KGlobal::locale()->insertCatalogue( "kaquarium" );
        return    new kfish( configFile, KPanelApplet::Normal,
                           KPanelApplet::About | KPanelApplet::Preferences,
                           parent, "kaquarium" );
    }
}

kfish *kfishApp = 0L;

kfish::kfish( const QString& configFile, Type type, int actions,
                QWidget *parent, const char *name )
                : KPanelApplet(configFile, type, actions, parent, name)
                , confDlg( 0 )
{
    kfishApp = this;
    
    // random
    srand( time(NULL) );
    
    //  Add layout
    QVBoxLayout *vbox;
    vbox = new QVBoxLayout(this);

    resize(200,200);

    connect( kfishPref::prefs() , SIGNAL( changePref() ), this, SIGNAL( signalSettingsChanged() ) );
    connect( this, SIGNAL( signalSettingsChanged() ), this, SLOT( slotSettingsChanged() ));
     
    // start canvas, where i'll show the fish
    m_canvas = new QCanvas( 0, "Canvas" );
    m_canvasview = new kfishCanvasView( m_canvas, this, "CanvasView" );
    vbox->add(m_canvasview);
    m_canvasview -> setCanvas( m_canvas );
    
    // set some canvas options    
    m_canvas->setBackgroundColor( QColor(0,0,100) );
    m_canvas->setAdvancePeriod( 30 );
    m_canvas->resize( 1 ,1 );
    m_canvas->setDoubleBuffering(true);
    
    // set the background
    setWall( locate("data", "kfish/pics/water.png"), m_canvas );

    // start bubbles
    m_bubble = new kfishBubbleManager( m_canvas, this );
    
    // put CanvasView inside the layout
    m_fish = new kfishManager( this );

    // Mouse tracking, so i know if the mouse is over the widget (fishCanvasView)
    setMouseTracking ( true );
    
    // set the default width space for future usage
    m_oldwidth = kfishPref::prefs() -> getWidth();
    
    // set the orientation
    kfishPref::prefs() -> setOrientation( orientation() );
}

kfish::~kfish(void)
{
    delete m_canvasview;
    delete m_fish;
    delete m_bubble;
    delete m_canvas;
}

int kfish::widthForHeight( int h ) const
{
    kfishPref::prefs() -> setOrientation(Horizontal);
    kfishPref::prefs() -> setPanelHeight(h);
    kfishPref::prefs() -> setPanelWidth(kfishPref::prefs() -> getWidth());
    

    // TODO: Get ride of this, do a emit with the new size... or something like that 
    m_canvas -> resize( kfishPref::prefs() -> getWidth(), int (h) ); 
    m_canvas -> setChanged( QRect(0,0, int(kfishPref::prefs() -> getWidth()), int (h)));
    
    return kfishPref::prefs() -> getWidth();
}

int kfish::heightForWidth( int w ) const
{
    kfishPref::prefs() -> setOrientation(Vertical);
    kfishPref::prefs() -> setPanelWidth(w);
    kfishPref::prefs() -> setPanelHeight(int(w/1.5));

    // i resize the canvas widget and this send a resized signal to all my classes and they do what they have to
    // TODO: Get ride of this, do a emit with the new size... or something like that
    m_canvas -> resize( int (w), int (w/1.5) ); 
    m_canvas -> setChanged( QRect(0,0,int (w), int (w/1.5)) );
    
    return (int) (w/1.5);
}

void kfish::orientationChange(Orientation orient)
{
    kfishPref::prefs() -> setOrientation( orient );
}

void kfish::slotAbout()
{
    KAboutData about("kAquarium", I18N_NOOP("KDE Aquarium Applet"), "1.0 Beta",
                     I18N_NOOP("KDE Aquarium"), 
                     KAboutData::License_GPL_V2, "(C) 2002-2004 Ramiro Tasquer",
                     I18N_NOOP("An Aquarium Applet\nfor kicker"),
                     "http://scofmb.sourceforge.net");

    about. addAuthor("Ramiro Tasquer", I18N_NOOP("Developer"), "tasquer@arnet.com.ar");
    about. addCredit("Jim Toomey", I18N_NOOP("All fish graphics"), "www.slagoon.com");
    about. addCredit("Tarzeau", I18N_NOOP("Bubbles graphics"), "tarzeau@space.ch");

    KAboutApplication a(&about, this);
    a.exec();
}

void kfish::slotPreferences(void)
{
    if (confDlg) {
        confDlg -> raise();
        return;
    }
    confDlg = new configDlg( this, 0, FALSE, Qt::WDestructiveClose );
    connect(confDlg, SIGNAL( destroyed() ), SLOT( slotConfigDlgDestroy() ));
    confDlg -> show();    
}

void kfish::slotSettingsChanged()
{
    if ( m_oldwidth != kfishPref::prefs() -> getWidth() )
    {
        m_oldwidth = kfishPref::prefs() -> getWidth();
        emit updateLayout();
    }
}

void kfish::slotConfigDlgDestroy()
{
    confDlg = 0;
}

void kfish::about()
{
    slotAbout();
}

void kfish::preferences()
{
    slotPreferences();
}
