//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;

/**

 This abstract class implements basic functionality for buffered
 input/output.
 Through the available methods, you can find out how many bytes are
 available for reading, how many are still unsent and you can peek at
 the buffered data.
 This class was intentionally written to resemble QSocket, because
 KExtendedSocket is a subclass of this one. This is so that applications
 written using QSocket's buffering characteristics will be more easily
 ported to the more powerful KExtendedSocket class.
 KBufferedIO already provides a powerful internal buffering algorithm. However,
 this does not include the I/O itself, which must be implemented in
 derived classes. Thus, to implement a class that does some I/O, you must
 override, in addition to the pure QIODevice methods, these two:

	<li>
	closeNow()
	</li>
	
	<li>
	waitForMore()
	</li>
	 If your derived class reimplements the buffering algorithm, you must then
 decide which buffering functions to override. For instance, you may want to
 change the protected functions like feedReadBuffer() and consumeReadBuffer().
 See {@link KBufferedIOSignals} for signals emitted by KBufferedIO
		@author Thiago Macieira <thiagom@mail.com>

		@short Buffered I/O.

*/
public class KBufferedIO extends KAsyncIO  {
	protected KBufferedIO(Class dummy){super((Class) null);}
	/**	
		 The modes for closed() signal
		   		@short    The modes for closed() signal
	*/
	public static final int availRead = 0x01;
	public static final int dirtyWrite = 0x02;
	public static final int involuntary = 0x10;
	public static final int delayed = 0x20;
	public static final int closedNow = 0x40;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Closes the stream now, discarding the contents of the
		 write buffer. That is, we won't try to flush that
		 buffer before closing. If you want that buffer to be
		 flushed, you can call QIODevice.flush(), which is blocking, and
		 then closeNow, or you can call QIODevice.close() for a delayed
		 close.
		   		@short    Closes the stream now, discarding the contents of the  write buffer.
	*/
	public native void closeNow();
	/**	
		 Sets the internal buffer size to value.
			 Not all implementations support this.
			 The parameters may be 0 to make the class unbuffered or -1
		 to let the class choose the size (which may be unlimited) or
		 -2 to leave the buffer size untouched.
			 Note that setting the write buffer size to any value smaller than
		 the current size of the buffer will force it to flush first,
		 which can make this call blocking.
			 The default implementation does not support setting the buffer
		 sizes. You can only call this function with values -1 for "don't care"
		 or -2 for "unchanged"
			@param rsize the size of the read buffer
			@param wsize the size of the write buffer
				@return true if setting both was ok. If false is returned, the
 buffers were left unchanged.
   
		@short    Sets the internal buffer size to value.
	*/
	public native boolean setBufferSize(int rsize, int wsize);
	public native boolean setBufferSize(int rsize);
	/**	
		 Returns the number of bytes available for reading in the read buffer
				@return the number of bytes available for reading
   
		@short    Returns the number of bytes available for reading in the read buffer
	*/
	public native int bytesAvailable();
	/**	
		 Waits for more data to be available and returns the amount of available data then.
			@param msec number of milliseconds to wait, -1 to wait forever
				@return -1 if we cannot wait (e.g., that doesn't make sense in this stream)
   
		@short    Waits for more data to be available and returns the amount of available data then.
	*/
	public native int waitForMore(int msec);
	/**	
		 Returns the number of bytes yet to write, still in the write buffer
				@return the number of unwritten bytes in the write buffer
   
		@short    Returns the number of bytes yet to write, still in the write buffer
	*/
	public native int bytesToWrite();
	/**	
		 Checks whether there is enough data in the buffer to read a line
			 The default implementation reads directly from inBuf, so if your
		 implementation changes the meaning of that member, then you must override
		 this function.
				@return true when there is enough data in the buffer to read a line
   
		@short    Checks whether there is enough data in the buffer to read a line
	*/
	public native boolean canReadLine();
	/**	
		 Reads into the user buffer at most maxlen bytes, but does not
		 consume that data from the read buffer. This is useful to check
		 whether we already have the needed data to process something.
			 This function may want to try and read more data from the system
		 provided it won't block.
			@param data the user buffer pointer, at least maxlen bytes long
			@param maxlen the maximum length to be peeked
				@return the number of bytes actually copied.
   
		@short    Reads into the user buffer at most maxlen bytes, but does not  consume that data from the read buffer.
	*/
	public native int peekBlock(String data, int maxlen);
	/**	
		 Unreads some data. That is, write the data to the beginning of the
		 read buffer, so that next calls to readBlock or peekBlock will see
		 this data instead.
			 Note not all devices implement this since this could mean a semantic
		 problem. For instance, sockets are sequential devices, so they won't
		 accept unreading.
			@param data the data to be unread
			@param len the size of the data
				@return the number of bytes actually unread
   
		@short    Unreads some data.
	*/
	public native int unreadBlock(String data, int len);
}
