/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2004 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef PROJECTPREFWIDGETS_H
#define PROJECTPREFWIDGETS_H

#include <ktabctl.h>
#include <qptrlist.h>
#include "projectsettings.h"


class KLineEdit;
class QLineEdit;
class QCheckBox;
class QComboBox;
class QListBox;
class QRadioButton;
class QSpinBox;
class CmdEdit;
class KFontChooser;
class KColorButton;
class KComboBox;
class KSpellConfig;
class KURLRequester;
class QPushButton;
class QGroupBox;
class KListEditor;
class ToolSelectionWidget;
class KIntNumInput;

struct ModuleInfo;

class SavePreferences : public KTabCtl
{
   Q_OBJECT
public:
   SavePreferences(QWidget* parent=0);
   void mergeSettings(KBabel::SaveSettings& settings) const;
   void setSettings(const KBabel::SaveSettings&);
   void defaults();
   void setAutoSaveVisible(const bool on);

private:
   QCheckBox* _lastButton;
   QCheckBox* _revisionButton;
   QCheckBox* _languageButton;
   QCheckBox* _charsetButton;
   QCheckBox* _encodingButton;
   QCheckBox* _projectButton;

   QCheckBox* _updateButton;
   QCheckBox* _autoCheckButton;
   QCheckBox* _saveObsoleteButton;

   QComboBox* _encodingBox;
   QCheckBox* _oldEncodingButton;

   QRadioButton* _defaultDateButton;
   QRadioButton* _localDateButton;
   QRadioButton* _customDateButton;
   QLineEdit* _dateFormatEdit;
   
   QLineEdit* _projectEdit;

   QRadioButton* _removeFSFButton;
   QRadioButton* _updateFSFButton;
   QRadioButton* _nochangeFSFButton;
   QCheckBox* _translatorCopyrightButton;

   QCheckBox* _descriptionButton;
   QLineEdit* _descriptionEdit;
   
   KIntNumInput * _autoSaveDelay;
   QGroupBox * _autoSaveBox;

private slots:
   void customDateActivated(bool on);
};


class IdentityPreferences : public QWidget
{
    Q_OBJECT
public:
    IdentityPreferences(QWidget *parent = 0, const QString& project = "");
    void mergeSettings(KBabel::IdentitySettings& settings) const;
    void setSettings(const KBabel::IdentitySettings&);
    void defaults();

    virtual bool eventFilter(QObject *, QEvent*);

private slots:
    void checkTestPluralButton();
    void testPluralForm();
    void lookupGnuPluralFormHeader();
    
private:
   QLineEdit* _nameEdit;
   QLineEdit* _localNameEdit;
   QLineEdit* _mailEdit;
   QLineEdit* _langEdit;
   QLineEdit* _langCodeEdit;
   QLineEdit* _listEdit;

   QLineEdit* _timezoneEdit;
   QSpinBox *_pluralFormsBox;
   QPushButton *_testPluralButton;
   QCheckBox* _checkPluralArgumentBox;
   QLineEdit* _gnuPluralFormHeaderEdit;
   QPushButton *_testGnuPluralFormButton;
};


class MiscPreferences : public QWidget
{
   Q_OBJECT
public:
   MiscPreferences(QWidget *parent=0);
   virtual ~MiscPreferences();

   void mergeSettings(KBabel::MiscSettings& settings) const;
   void setSettings(const KBabel::MiscSettings&);
   void defaults();

private slots:
   void regExpButtonClicked();
   
private:
   void setContextInfo(QString reg);
   QString contextInfo() const;
   
   KLineEdit *contextInfoEdit;
   KLineEdit *accelMarkerEdit;
   
   QDialog *_regExpEditDialog;
   QPushButton *_regExpButton;

   QRadioButton* bzipButton;
   QRadioButton* gzipButton;
   QCheckBox* compressSingle;
};

class SpellPreferences : public QWidget
{
public: 
    SpellPreferences(QWidget *parent=0);
    
    void mergeSettings(KBabel::SpellcheckSettings& set) const;
    void setSettings(const KBabel::SpellcheckSettings&);
    void defaults();

private:
    KSpellConfig* spellConfig;
    QCheckBox* remIgnoredBtn;
    QCheckBox* onFlyBtn;
    KURLRequester* ignoreURLEdit;

};

class CatmanPreferences : public QWidget
{
    Q_OBJECT
public:
    CatmanPreferences(QWidget *parent = 0);
    virtual ~CatmanPreferences();

    void mergeSettings(KBabel::CatManSettings& settings) const;
    void setSettings(const KBabel::CatManSettings&);
    void defaults();

private:
    KURLRequester* _poDirEdit;
    KURLRequester* _potDirEdit;

    QCheckBox* _openWindowButton;

    QCheckBox* _killButton;
    QCheckBox* _indexButton;
};

class DirCommandsPreferences : public QWidget
{
    Q_OBJECT
public:
    DirCommandsPreferences(QWidget *parent = 0);
    virtual ~DirCommandsPreferences();

    void mergeSettings(KBabel::CatManSettings& settings) const;
    void setSettings(const KBabel::CatManSettings&);
    void defaults();

private:
    CmdEdit* _dirCmdEdit;
};

class FileCommandsPreferences : public QWidget
{
    Q_OBJECT
public:
    FileCommandsPreferences(QWidget *parent = 0);
    virtual ~FileCommandsPreferences();

    void mergeSettings(KBabel::CatManSettings& settings) const;
    void setSettings(const KBabel::CatManSettings&);
    void defaults();

private:
    CmdEdit* _fileCmdEdit;
};

class ViewPreferences : public QWidget
{
    Q_OBJECT
public:
    ViewPreferences(QWidget *parent = 0);
    virtual ~ViewPreferences();

    void mergeSettings(KBabel::CatManSettings& settings) const;
    void setSettings(const KBabel::CatManSettings&);
    void defaults();

private:
    QCheckBox* _flagColumnCheckbox;
    QCheckBox* _fuzzyColumnCheckbox;
    QCheckBox* _untranslatedColumnCheckbox;
    QCheckBox* _totalColumnCheckbox;
    QCheckBox* _cvsColumnCheckbox;
    QCheckBox* _revisionColumnCheckbox;
    QCheckBox* _translatorColumnCheckbox;
};

#endif // PROJECTPREFWIDGETS_H
