/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MISCPROPERTIES_H
#define MISCPROPERTIES_H

#include "MiscProperties_base.h"

class DDataItem;
class BoxURL;
class MiscProperties : public MiscProperties_base
{
    Q_OBJECT

    public:
	MiscProperties( QWidget* parent, const char* name=0);
	~MiscProperties();

    protected:
	void resizeEvent( QResizeEvent* );

    public slots:
        void setCurrentItem(DDataItem*);
	void updateItem();

    private:
	DDataItem *m_lastitem;
	BoxURL* m_boxurl;
	void dispInitialPixmap();
};

#endif // MISCPROPERTIES_H
