/***************************************************************************
                          kfmproject.h  -  description
                             -------------------
    begin                : Thu Aug 30 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFMPROJECT_H
#define KFMPROJECT_H

#include <qobject.h>
#include <qstring.h>
#include <qdom.h>

class KFMTaskList;
class KFMLogBook;

/**Project model class
  *@author Jeffrey Yu
  */

class KFMProject : public QObject  {
Q_OBJECT
public: 
	KFMProject();
	~KFMProject();
	
	QString name() const;
	void name(QString name);
	
	KFMTaskList* taskList() const;
	KFMLogBook* logBook() const;
	
	void clear();

	static QString xmlTag();
	QDomElement domElement(QDomDocument* d);
	void domElement(QDomElement eProject);
	
	/** Get the project id */
	int id() const {return id_;};
	/** Set the project id.  The id is normally set from the
			projectlist. */
	void id(const int id) {id_ = id;};
	
signals:
	void nameChanged();
	void contentsChanged();
		
private /* attributes */:
	QString name_;
	KFMTaskList* taskList_;
	KFMLogBook* logBook_;
	
	/** Project id */
	int id_;
	
private /* methods */:
	void taskList(KFMTaskList* taskList);
	void logBook(KFMLogBook* logBook);
	
	void createWidgets();
	
private slots:
	void onTaskListContentsChanged();
	void onLogBookContentsChanged();
};

#endif
