#ifndef KP_CALENDAR_TIME_
#define KP_CALENDAR_TIME_

#include <glib.h>
#include <glib-object.h>

typedef struct 
{
  GObject        parent_instance;

  GDate         *date;

  guint          h;
  guint          m;
  guint          s;
  guint          t; /* thousandths */
  
} KPCalendarTime;

typedef struct
{
  GObjectClass parent_class;
} KPCalendarTimeClass;

GType kp_calendar_time_get_type ();
KPCalendarTime *kp_calendar_time_new ();
KPCalendarTime *kp_calendar_time_new_dmyhms (guint d, guint m, guint y,
                                             gint h, gint min, gint s);

gboolean kp_calendar_time_set_dmy (KPCalendarTime *ct, guint d, guint m, guint y);
gboolean kp_calendar_time_set_hmst (KPCalendarTime *ct, guint h, guint m, guint s, guint t);
gboolean kp_calendar_time_set_date (KPCalendarTime *ct, GDate *date);
gboolean kp_calendar_time_set_datetime (KPCalendarTime *ct, const gchar *datetime);
gboolean kp_calendar_time_set_hmst_str (KPCalendarTime *ct, const gchar *time);

gchar *kp_calendar_time_to_str_hmst (KPCalendarTime *ct);

GDate *kp_calendar_time_get_date (KPCalendarTime *ct);

#define KP_TYPE_CALENDAR_TIME (kp_calendar_time_get_type())
#define KP_CALENDAR_TIME(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_CALENDAR_TIME, KPCalendarTime))
#define KP_CALENDAR_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_CALENDAR_TIME, KPCalendarTimeClass))
#define KP_IS_CALENDAR_TIME(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_CALENDAR_TIME))
#define KP_IS_CALENDAR_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_CALENDAR_TIME))
#define KP_CALENDAR_TIME_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_CALENDAR_TIME, KPCalendarTimeClass))

#endif
