/***************************************************************************
                       iptrule.h  -  description
                          -------------------
 begin                : Mon Feb 4 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTRULE_H
#define IPTRULE_H

#include "netfilterobject.h"

#include <qptrlist.h>
#include <qdict.h> 
/**
  *@author Christian Hubinger
  */
class QString;
class IPTChain;
class IPTable;
class KMFError;
class KMFCheckInput;
/** This class represents one "Rule" in the ruleset needed to settup
		the firewall those rule look like: $IPT -A CHAINNAME [ OPTIONS ] -j TARGET [ OPTIONS ]
*/
class IPTRule : public NetfilterObject {
public:
	/** The only constructor that sets the name,chain,target and table.
	*/
	IPTRule( const QString& name , IPTChain* chain , const QString& target );
	~IPTRule();

	/** Sets the name of the rule to name.
	*/
	KMFError* setName( const QString& name ); // name displayed

	/** Sets the Chain of the rule to chain
	*/
	void setChain( IPTChain* chain ); // chain for which this Rule applies

	/**  Sets the Target of the rule to target
	*/
	void setTarget( const QString& target ); // Target for the Rule

	/** Sets the Table of the rule to table
	*/
	void setTable( IPTable* table ); // set IPTable to use default="filter"

	/** Enable/Disable cmd line generation for this rule
	*/
	void setEnabled( bool on ) {
		m_enabled = on;
	};

	/** Return true if the Rule is enabled; else returns false
	*/
	bool enabled() const {
		return m_enabled;
	};

	/** Enable/Disable logging rule for this rule
	*/
	void setLogging( bool on ) {
		m_log_rule = on;
	};

	/** Return true if the rule logging is turend on; else returns false
	*/
	bool logging() const {
		return m_log_rule;
	};


	/** Sets the rule number
	*/
	void setRuleNum( int num );

	/** Addes a ruleoption defined the a string optionname p.e "scr_ip" "state"..
			and the strings needed to define all options is given by the list options values of the
	*/
	bool addRuleOption( QString& optionname, QPtrList<QString>& options );

	/** Deletes the rule option given by the optioname
	*/
	bool delRuleOption( const QString& optionname );

	/** Not Implemented yet
	*/
	bool addTargetOption( QString& optionname, QPtrList<QString>& options );

	/** Not Implemented yet
	*/
	bool delTargetOption( const QString& opt_name );

	/** Returns the name of the rule
	*/
	const QString& name() const;

	/** Returns the description of the rule the user has set
	*/
//	const QString& description() const {
//		return m_desc;
//	};

//  /** Set the description for this rule
//  */
//	void setDescription(const QString& desc);

	
	/** Returns the chain to which this rule belongs
	*/
	IPTChain* chain() const {
		return m_chain;
	} ;

	/** Returns the table to which this rule belongs
	*/
	IPTable* table() const {
		return m_table;
	} ;

	/** Returns the target of the rule
	*/
	const QString& target() const ;


	/** Return the rule number in it's chain
	*/
	int ruleNum() const;

  /** Return true if this is a rule eith custom options
  */
  bool customRule() const { return m_custom_rule; };
  
  /** Set the custom rule flag
  */
  void setCustomRule( bool );

	/** Returns the commandline that this rule represents
	*/
	const QString& cmdString();

	/** Returns a list of Lists where the first item is the optionname
			and the others are the values for the specific sub_options (p.e. portnumbers) (p.e [tcp,80,12,32,23]
	*/
	QPtrList<QPtrList<QString> >& ruleOptions() const;


	/** Returns a list of Lists where the first item is the optionname
			and the others are the values for the specific sub_options (p.e. portnumbers) (p.e [tcp,80,12,32,23]
	*/
	QPtrList<QPtrList<QString> >& ruleTargetOptions() const;

	/** Creates a deep copy of the rule
	*/
	IPTRule* createRuleClone();
private:

	/** The name of the rule
	*/
	QString m_name;

	/**  The chain of the rule
	*/
	IPTChain *m_chain;

	/** The table of the rule
	*/
	IPTable *m_table;

	/** The target of the rule
	*/
	QString m_target;

//  /** The Description
//	*/
//	QString m_desc;
	
	/** The number of the rule in it's chain
	*/
	int m_rule_num;


	/** Dictionary which returns the option command string by using the optionname as key
	(p.e "src_ip" -> --source)
	*/
	QDict<QString> available_options;

	/** Dictionary which returns the option command string by using the optionname as key
	(p.e "log_level" -> --log_level)
	*/
	QDict<QString> available_target_options;

	/**
	*/
	QDict<QPtrList<QString> > used_options; //option name -> values

	/**
	*/
	QDict<QPtrList<QString> > used_target_options; //option name -> values

	/**
	*/
	QPtrList<QPtrList<QString> > option_list; // [ [tcp,20,32,ACK,FIN RST,0],[udp,20,32,] ]

	/**
	*/
	QPtrList<QPtrList<QString> > target_option_list; // [ [tcp,20,32,ACK,FIN RST,0],[udp,20,32,] ]

	KMFError *m_err;
	KMFCheckInput *m_check_input;


	void setUpKnownRules();
	bool m_enabled, m_log_rule, m_custom_rule;


	void cmdString_loop( QString find, bool target );
	QString opt, ipt_cmd, tab, ap, ws, post, option_cmd;
};

#endif
