/***************************************************************************
                          dlg_settings.cpp  -  description
                             -------------------
    begin                : Mon Jul 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kicontheme.h>
#include <kstddirs.h>
#include "definitions.h"
#include "dlg_settings.moc"
#include "setpagedisplay.h"
#include "setpageaudio.h"
#include "setpageengines.h"
#include "setpageservers.h"
#include "setpagegeneral.h"

///////////////////////////////////////
//
//	dlg_settings::Constructor
//
///////////////////////////////////////
dlg_settings::dlg_settings(QWidget *parent, const char *name, resource *Rsrc ) :
	KDialogBase(	IconList,
								i18n("Configure"),
								Help|Ok|Apply|Cancel,
								Ok,
								parent,
								name,
								FALSE,
								FALSE )
{
	QString buffer;
	Resource = Rsrc;
	Resource->ConfigWrite();

	/* General Page */
	FRAME_General = addPage(	i18n( "General" ),
														i18n( "Various aspects of Knights get configured here." ),
														QPixmap( locate( "data", "knights/icon-general.png" ) ) );
	PAGE_General = new setPageGeneral( FRAME_General, Resource );
	connect( PAGE_General, SIGNAL( enableApply() ), this, SLOT( slotEnableApply() ) );

	/* Display Page */
	FRAME_Display = addPage(	i18n( "Display" ),
														i18n( "These settings determine how Knights displays itself to you." ),
														QPixmap( locate( "data", "knights/icon-display.png" ) ) );
	PAGE_Display = new setPageDisplay( FRAME_Display, Resource );
	connect( PAGE_Display, SIGNAL( enableApply() ), this, SLOT( slotEnableApply() ) );

	/* Audio Page */
	FRAME_Audio = addPage(	i18n( "Audio" ),
														i18n( "These settings determine what Knights sounds like." ),
														Resource->LoadIcon( QString("multimedia"), KIcon::Panel ) );
	PAGE_Audio = new setPageAudio( FRAME_Audio, Resource );
	connect( PAGE_Audio, SIGNAL( enableApply() ), this, SLOT( slotEnableApply() ) );

	/* Engines Page */
	FRAME_Engines = addPage(	i18n( "Computer Opponents" ),
														i18n( "Configure your chess engines here." ),
														Resource->LoadIcon( QString("gear"), KIcon::Panel ) );
	PAGE_Engines = new setPageEngines( FRAME_Engines, Resource );
	connect( PAGE_Engines, SIGNAL( enableApply() ), this, SLOT( slotEnableApply() ) );

	/* Servers Page */
	FRAME_Servers = addPage(	i18n( "Chess Servers" ),
														i18n( "Configure your internet chess servers here." ),
														Resource->LoadIcon( QString("network"), KIcon::Panel ) );
	PAGE_Servers = new setPageServers( FRAME_Servers, Resource );
	connect( PAGE_Servers, SIGNAL( enableApply() ), this, SLOT( slotEnableApply() ) );

	connect( this, SIGNAL( aboutToShowPage( QWidget* ) ), this, SLOT( slotPageChanging( QWidget* ) ) );

	/* Init the buttons */
	showButtonCancel( TRUE );
	showButtonOK( TRUE );
	showButtonApply( TRUE );
	showButton( Help, TRUE );

	enableButtonCancel( TRUE );
	enableButtonOK( TRUE );
	enableButtonApply( FALSE );
	enableButton( Help, TRUE );

	setHelp( QString( "configure" ) );
	show();
}
///////////////////////////////////////
//
//	dlg_settings::Destructor
//
///////////////////////////////////////
dlg_settings::~dlg_settings()
{
}
///////////////////////////////////////
//
//	dlg_settings::slotOk
//
///////////////////////////////////////
void dlg_settings::slotOk( void )
{
	slotApply();
	slotDelayedDestruct();
}
///////////////////////////////////////
//
//	dlg_settings::slotApply
//
///////////////////////////////////////
void dlg_settings::slotApply( void )
{
	if( PAGE_Display->changeTheme )
	{
		PAGE_Display->changeTheme = FALSE;
		emit themeChanged( PAGE_Display->NewBoards, PAGE_Display->NewChessmen );
	}
	if( PAGE_Display->refreshBoard )
	{
		PAGE_Display->refreshBoard = FALSE;
		emit redrawBoard();
	}
	if( PAGE_Display->rebuildConsole )
	{
		Resource->buildStyle();
		PAGE_Display->rebuildConsole = FALSE;
		emit rebuildConsole();
	}
	if( PAGE_Audio->changeTheme )
	{
		PAGE_Audio->changeTheme = FALSE;
		Resource->setAudio( PAGE_Audio->NewSounds );
	}
	if( PAGE_Servers->resetServer )
	{
		PAGE_Servers->resetServer = FALSE;
		emit resetServer();
	}
	Resource->ConfigWrite();
	enableButtonApply( FALSE );
}
///////////////////////////////////////
//
//	dlg_settings::slotCancel
//
///////////////////////////////////////
void dlg_settings::slotCancel( void )
{
	Resource->ConfigRead();
	slotDelayedDestruct();
}
///////////////////////////////////////
//
//	dlg_settings::slotEnableApply
//
///////////////////////////////////////
void dlg_settings::slotEnableApply( void )
{
	enableButtonApply( TRUE );
}
///////////////////////////////////////
//
//	dlg_settings::slotThemesAdded
//
///////////////////////////////////////
void dlg_settings::slotThemesAdded( void )
{
	PAGE_Display->buildThemeList();
	PAGE_Audio->buildThemeList();
}
///////////////////////////////////////
//
//	dlg_settings::slotPageChanging
//
///////////////////////////////////////
void dlg_settings::slotPageChanging( QWidget *page )
{
	if( page == FRAME_General )
		setHelp( QString( "configure-general" ) );
	else if( page == FRAME_Display )
		setHelp( QString( "configure-display" ) );
	else if( page == FRAME_Audio )
		setHelp( QString( "configure-audio" ) );
	else if( page == FRAME_Engines )
		setHelp( QString( "configure-engines" ) );
	else if( page == FRAME_Servers )
		setHelp( QString( "configure-servers" ) );
}



