/***************************************************************************
                          tabpage.cpp  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabpage.moc"
#include "tabmanager.h"
#include "tabgrip.h"
#include "resource.h"
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>
#include <qlayout.h>
#include <qtoolbutton.h>

///////////////////////////////////////
//
//	TabPage::constructor
//
///////////////////////////////////////
TabPage::TabPage( QWidget *parent, QWidget *child, resource *rsrc ) : QVBox(parent)
{
	myResource = rsrc;
	myChild = child;

	actionBar = new QHBox( this );
	actionBar->show();

	grip = new TabGrip( actionBar );
	connect( grip, SIGNAL( wasDragged(const QPoint&, const QPoint&) ), this, SLOT( tabDragged(const QPoint&, const QPoint&) ) );

	KIconLoader icons( QString( "knights" ) );
	QPixmap map = icons.loadIcon( QString("tab_remove"), KIcon::Small, 0, KIcon::DefaultState, 0, TRUE );
	if( map.isNull() )
	{
		/* Keep for backward compatability with KDE 3.0 */
		map = icons.loadIcon( QString("fileclose"), KIcon::Small );
	}

	closeButton = new QToolButton( actionBar, "closeButton" );
	closeButton->setIconSet( QIconSet( map ) );
	closeButton->setAutoRaise( TRUE );
	closeButton->setTextLabel( i18n( "Close This Tab" ), TRUE );
	closeButton->setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed ) );
	connect( closeButton, SIGNAL( clicked() ), this, SIGNAL( requestDestruction() ) );

	myChild->reparent( this, QPoint( 0, 0 ), TRUE );
	myChild->show();
	show();
}
///////////////////////////////////////
//
//	TabPage::destructor
//
///////////////////////////////////////
TabPage::~TabPage()
{
}
///////////////////////////////////////
//
//	TabPage::tabDragged
//
///////////////////////////////////////
void TabPage::tabDragged( const QPoint &dest, const QPoint &offset )
{
	TabBox *myParent = parentTabBox();
	if( myParent != NULL )
	{
		QWidget *destWidget = QApplication::widgetAt( dest, TRUE );
		/* Find a TabBox */
		while(1)
		{
			if( destWidget == NULL )
			{
				/* Create new TabBox */
				TabBox *newBox = new TabBox( myResource );
				newBox->resize( myParent->size() );
				newBox->move( dest + offset );
				newBox->show();
				emit newParent( newBox );
				myParent->removeTab( this );
				newBox->addTab( this, myCaption );
				break;
			}
			if( QString( destWidget->className() ) == "TabBox" )
			{
				if( myParent != ((TabBox*)destWidget) )
				{
					/* We can latch on here */
					myParent->removeTab( this );
					((TabBox*)destWidget)->addTab( this, myCaption );
					break;
				}
				else
				{
					break;
				}
			}
			destWidget = destWidget->parentWidget();
		}
		if( myParent->count() == 0 )
		{
			/* TabManager will be notified of the delete via QObject::destroyed(QObject*) */
			delete myParent;
		}
	}
	else
	{
		kdError() << "TabPage::tabDragged: Can not move without a parent TabBox." << endl;
	}
}
///////////////////////////////////////
//
//	TabPage::setCaption
//
///////////////////////////////////////
void TabPage::setCaption( const QString &caption )
{
	myCaption = caption;
}
///////////////////////////////////////
//
//	TabPage::parentTabBox
//
///////////////////////////////////////
TabBox* TabPage::parentTabBox( void )
{
	QWidget *myParent = this->parentWidget();
	if( QString( myParent->className() ) == "QWidgetStack" )
	{
		myParent = myParent->parentWidget();
		if( QString( myParent->className() ) == "QTabWidget" )
		{
			myParent = myParent->parentWidget();
			if( QString( myParent->className() ) == "TabBox" )
			{
				return ((TabBox*)myParent);
			}
		}
	}
	return NULL;
}
///////////////////////////////////////
//
//	TabPage::getChild
//
///////////////////////////////////////
QWidget* TabPage::getChild( void )
{
	return myChild;
}

