/***************************************************************************
                          autocallchexdlg.cpp  -  description
                             -------------------
    begin                : Tue Sep 26 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "autocallchexdlg.h"
#include "globals.h"
#include <klocale.h>
#include <qlayout.h>

autocallchexDlg::autocallchexDlg(QWidget *parent)
  : KDialogBase(parent, "autocallchexDlg", true, i18n("Enable Auto Call Checking"), Ok|Cancel, Ok, true) {
    setWFlags (WDestructiveClose);

	QLabel* l;
	QWidget* w;
	QGridLayout* grid;

	w = new QWidget (this);
	setMainWidget (w);

	grid = new QGridLayout (w, -1, -1, 10, 5);

  	l = new QLabel (w);

		callCheckBox = new QCheckBox (w);
		callCheckBox->setText (i18n ("Enable Automatic Call Check Operation"));
		callCheckBox->setChecked (config.logbook.callchex);
		grid->addWidget (callCheckBox, 0, Qt::AlignHCenter);
		}

autocallchexDlg::~autocallchexDlg()
{
}

void autocallchexDlg::slotOk()
{
  config.logbook.callchex = callCheckBox->isChecked();
  kpsk->reInit();
	KDialogBase::slotOk();
}
