/***************************************************************************
                          replacedialog.cpp  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Own includes
#include "replacedialog.h"

// QT includes
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qregexp.h>

// KDE includes
#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <kparts/componentfactory.h>
#include <kpushbutton.h>
#include <kregexpeditorinterface.h>

ReplaceDialog::ReplaceDialog( QValueList<replacestrings> r, QWidget* parent )
    : KDialogBase( KDialogBase::Plain, i18n( "Find and Replace" ),
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent, 0, true, true )
{
    ReplaceDialogLayout = new QGridLayout( plainPage(), 11, 6);

    list = new KListView( plainPage() );
    list->addColumn( i18n("Find") );
    list->addColumn( i18n("Replace With") );
    list->addColumn( i18n("Regular Expression") );
    list->addColumn( "regexp" ); // no i18n, because not user visible
//    list->setColumnWidthMode( 0, QListView::Manual );
//    list->setColumnWidthMode( 1, QListView::Manual );
//    list->setColumnWidthMode( 2, QListView::Manual );
    list->setColumnWidthMode( 3, QListView::Manual );
    list->setColumnWidth( 3, 0 );
    list->setSorting( -1 );
    list->setAllColumnsShowFocus( true );
        
    TextLabel1 = new QLabel( plainPage() );
    TextLabel1->setText( i18n( "Find:" ) );
    TextLabel2 = new QLabel( plainPage() );
    TextLabel2->setText( i18n( "Replace with:" ) );

    text1 = new QLineEdit( plainPage() );
    text2 = new QLineEdit( plainPage() );

    checkReg = new QCheckBox( i18n("&Regular expression"), plainPage() );
    buttonRegEdit = new KPushButton( plainPage() );
    buttonRegEdit->setText( i18n( "&Edit..." ) );
    buttonRegEdit->setEnabled( false );

    buttonAdd = new KPushButton( plainPage() );
    buttonAdd->setText( i18n( "&Add" ) );

    buttonEdit = new KPushButton( plainPage() );
    buttonEdit->setText( i18n("&Edit") );
    
    buttonRemove = new KPushButton( plainPage() );
    buttonRemove->setText( i18n( "&Remove" ) );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );

    ReplaceDialogLayout->addWidget( TextLabel1, 0, 0 );
    ReplaceDialogLayout->addWidget( text1, 0, 1 );

    ReplaceDialogLayout->addWidget( TextLabel2, 0, 3 );
    ReplaceDialogLayout->addWidget( text2, 0, 4 );

    ReplaceDialogLayout->addWidget( checkReg, 1, 0 );
    ReplaceDialogLayout->addWidget( buttonRegEdit, 1, 1 );

    ReplaceDialogLayout->addWidget( buttonAdd, 0, 6 );
    ReplaceDialogLayout->addWidget( buttonEdit, 1, 6 );
    ReplaceDialogLayout->addWidget( buttonRemove, 2, 6 );
    
    ReplaceDialogLayout->addItem( spacer, 0, 5 );
    ReplaceDialogLayout->addItem( spacer, 0, 2 );
    ReplaceDialogLayout->addMultiCellWidget( list, 3, 3, 0, 4 );
    
    text1->setFocus();

    connect( buttonAdd, SIGNAL( clicked() ), this, SLOT( add() ) );
    connect( buttonRemove, SIGNAL( clicked() ), this, SLOT( remove() ) );
    connect( list, SIGNAL( clicked( QListViewItem* ) ), this, SLOT( enableControls() ) );
    connect( list, SIGNAL( doubleClicked( QListViewItem* ) ), this, SLOT( slotEdit() ) );
    connect( text2, SIGNAL( returnPressed() ), this, SLOT( add() ) );
    connect( text1, SIGNAL( returnPressed() ), this, SLOT( moveFocus() ) );
    connect( buttonRegEdit, SIGNAL( clicked() ), this, SLOT( invokeRegEdit() ) );
    connect( checkReg, SIGNAL( clicked() ), this, SLOT( enableControls() ) );
    connect( buttonEdit, SIGNAL( clicked() ), this, SLOT( slotEdit() ) );

    for( unsigned int i = 0; i < r.count(); i++ ) {
        replacestrings rs = r[i];

        rs.find = BatchRenamer::unEscape( rs.find );

        KListViewItem* item = new KListViewItem( list );
        item->setText( 0, encode( rs.find ) );
        item->setText( 1, encode( rs.replace ) );
        item->setText( 2, rs.reg ? i18n("yes") : i18n("no") );
        item->setText( 3, QString::number( rs.reg ) );
        list->insertItem( item );
    }

    enableControls();
}

ReplaceDialog::~ReplaceDialog()
{ }

void ReplaceDialog::add()
{
    if( text1->text().isEmpty() ) {
        KMessageBox::sorry( this, i18n( "Add a text that should be replaced." ) );
        return;
    }

    QListViewItem* it = list->firstChild();
    while( it ) {
        if( it->text( 0 ) == text1->text() ) {
            KMessageBox::sorry( this, i18n( "You can't replace the same text twice." ) );
            return;
        }
        it = it->nextSibling();
    }

    KListViewItem* item = new KListViewItem( list, i18n("Regular expression") );
    item->setText( 0, encode( text1->text() ) );
    item->setText( 1, encode( text2->text() ) );
    item->setText( 2, checkReg->isChecked() ? i18n("yes") : i18n("no") );    
    item->setText( 3, QString::number( checkReg->isChecked() ) );
    list->insertItem( item );

    reset();

    enableControls();
}

void ReplaceDialog::remove()
{
    if( list->selectedItem() ) {
        QListViewItem* item = list->selectedItem();
        list->takeItem( item );
        delete item;
    }

    enableControls();    
}

QValueList<replacestrings> ReplaceDialog::getList()
{
    QValueList<replacestrings> r;
    QListViewItem* item = list->firstChild();
    while( item ) {
        replacestrings n;
        n.find = BatchRenamer::doEscape( decode( item->text( 0 ) ) );
        n.replace = decode( item->text( 1 ) );
        n.reg = item->text( 3 ).toInt();

        r.append( n );

        item = item->nextSibling();
    }
    return r;
}

void ReplaceDialog::moveFocus()
{
    text2->setFocus();
}

void ReplaceDialog::invokeRegEdit()
{
    QDialog* regExpDialog = KParts::ComponentFactory::createInstanceFromQuery<QDialog>( "KRegExpEditor/KRegExpEditor", QString::null, this );

    KRegExpEditorInterface *iface = static_cast<KRegExpEditorInterface *>( regExpDialog->qt_cast( "KRegExpEditorInterface" ) );
    if ( !iface )
        return;

    iface->setRegExp( text1->text() );
    bool ok = regExpDialog->exec();
    if ( ok )
        text1->setText( iface->regExp() );
}

QString ReplaceDialog::encode( QString s )
{
    s.append("\"");
    s.prepend("\"");
    return s;
}

QString ReplaceDialog::decode( QString s )
{
    if( s[0] == '"' )
        s.remove( 0, 1 );

    if( s[s.length()-1] == '"' )
        s.remove( s.length()-1, 1 );
    return s;
}

void ReplaceDialog::resizeEvent( QResizeEvent* e )
{
    QDialog::resizeEvent( e );
//    list->setColumnWidth( 0, TextLabel1->width() + text1->width() );
//    list->setColumnWidth( 1, TextLabel2->width() + text2->width() );
}

void ReplaceDialog::reset()
{
    text1->clear();
    text2->clear();
    checkReg->setChecked( false );
    text1->setFocus();
}

void ReplaceDialog::enableControls()
{
    buttonRemove->setEnabled( list->selectedItem() );
    buttonRegEdit->setEnabled( checkReg->isChecked() && !KTrader::self()->query("KRegExpEditor/KRegExpEditor").isEmpty() );
    buttonEdit->setEnabled( list->selectedItem() );
}

void ReplaceDialog::slotEdit()
{
    text1->setText( decode( list->selectedItem()->text( 0 ) ) );
    text2->setText( decode( list->selectedItem()->text( 1 ) ) );
    checkReg->setChecked( list->selectedItem()->text( 3 ).toInt() );

    QListViewItem* item = list->selectedItem();
    list->takeItem( item );
    delete item;
    
    text1->setFocus();

    enableControls();
}
