#ifndef _KVI_DEFINES_H_INCLUDED_
#define _KVI_DEFINES_H_INCLUDED_

// =============================================================================
//
//      --- kvi_defines.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_settings.h"

#ifndef VERSION
	#define VERSION "?.?.?"
#endif

#ifndef BUILD_DATE
	#define BUILD_DATE "?"
#endif

// We want _GNU_SOURCE features
#ifndef _GNU_SOURCE
	#define _GNU_SOURCE
#endif

#define KVI_RELEASE_NAME "'Renaissance'"

#define KVI_VERSION "KVIrc " VERSION " " KVI_RELEASE_NAME
#define KVI_SCRIPT_LANGUAGE_TAG         "20000521"
#define KVI_NUMERIC_SCRIPT_LANGUAGE_TAG  20000521

#define KVI_SPLASHSCREEN_FIXED_TEXT "Version <b>" VERSION "</b> - Brought to you by the KVIrc staff"
//
// Before you say anything...
#define KVI_OLD_HOME_CONFIG_FILE_NAME     ".kvirc-2.1.2.rc"
#define KVI_HOME_CONFIG_FILE_NAME         ".kvircrc"
#define KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME ".kvirc"

// ===========================================================================
// Default nickname, username... * Freely customizable
// ===========================================================================
#define KVI_DEFAULT_USERNAME  "nobody"
#define KVI_DEFAULT_REALNAME  "KVIrc " VERSION " " KVI_RELEASE_NAME
#define KVI_DEFAULT_NICKNAME1 "newbie"
#define KVI_DEFAULT_NICKNAME2 "newbie_"

#ifdef _KVI_OPTIONS_CPP_
	// Default config return values
	#define KVI_DEFAULT_PART_MESSAGE    "I am leaving"
	#define KVI_DEFAULT_QUIT_MESSAGE    "I am going away"
	#define KVI_DEFAULT_KICK_MESSAGE    "Go sit in a corner..."
	#define KVI_DEFAULT_CAPTION_MESSAGE "KVIrc " VERSION " " KVI_RELEASE_NAME
#endif

#define KVI_CTCP_VERSION_REPLY    "KVIrc " VERSION " " KVI_RELEASE_NAME " : build unknown " BUILD_DATE
#define KVI_CTCP_CLIENTINFO_REPLY "CLIENT: KVIrc, RELEASE: " VERSION " " KVI_RELEASE_NAME ", BUILD DATE: " BUILD_DATE ", SCRIPT_LANGUAGE_TAG: " KVI_SCRIPT_LANGUAGE_TAG
#define KVI_CTCP_SOURCE_REPLY     "URL: http://packages.qa.debian.org/kvirc"

// ===========================================================================
// Default window size * Freely customizable
// ===========================================================================
#ifdef _KVI_WINDOW_CPP_
	#define KVI_WINDOW_MIN_WIDTH  200
	#define KVI_WINDOW_MIN_HEIGHT 105
#endif

// ===========================================================================
// System window names * Customizable but remember to start the names with '@'
// ===========================================================================
#define KVI_CONSOLE_WINDOW_NAME          "@Console"
#define KVI_HELPWINDOW_WINDOW_NAME       "@Help Browser"
#define KVI_DIRECTORYBROWSER_WINDOW_NAME "@Directory Browser"
#define KVI_LINKS_WINDOW_NAME            "@Server Links"
#define KVI_LIST_WINDOW_NAME             "@Channel List"

// ===========================================================================
// Window types * Do not change
// ===========================================================================

#define KVI_WND_TYPE_CONSOLE     0
#define KVI_WND_TYPE_CHANNEL     1
#define KVI_WND_TYPE_QUERY       2
#define KVI_WND_TYPE_CHAT        3
#define KVI_WND_TYPE_SEND        4
#define KVI_WND_TYPE_VOICE       5
#define KVI_WND_TYPE_LINKS       6
#define KVI_WND_TYPE_LIST        7
#define KVI_WND_TYPE_UWINDOW     8
#define KVI_WND_TYPE_PLUGIN      9
#define KVI_WND_TYPE_DIRBROWSER 10

// ===========================================================================
// IrcListBox stuff * Ask yourself what you are doing while changing it.
// ===========================================================================

#ifdef _KVI_USERLISTBOX_CPP_
	// Scrollbar width
	#define KVI_USERLISTBOX_SCROLLBAR_WIDTH   16
	#define KVI_USERLISTBOX_VERTICAL_BORDER    4
	#define KVI_USERLISTBOX_HORIZONTAL_BORDER  4
	// > SCROLLBAR_WIDTH!
	#define KVI_USERLISTBOX_MINIMUM_WIDTH      0
	#define KVI_USERLISTBOX_MINIMUM_HEIGHT    32
	// This is the time in milliseconds that the user mask will
	// be shown in the statusBar when you select an item in the list box
	#define KVI_USERLISTBOX_USERMASK_STATUSBAR_SHOW_TIME 5000
#endif

// ===========================================================================
// IrcView stuff * Ask yourself what you are doing while changing it.
// ===========================================================================

#if defined(_KVI_IRC_VIEW_CPP_) || defined(_KVI_OPTIONS_CPP_) || defined(_KVI_OPTIONS_VIEW_CPP_)
	// Maximum size of the internal buffer for each window
	// This is the default value, in the near future it will be
	// settable by GUI.
	#define KVI_IRC_VIEW_MAX_LINES 1024
	// Borders. Just do not set it to 0
	#define KVI_IRC_VIEW_HORIZONTAL_BORDER  4
	#define KVI_IRC_VIEW_VERTICAL_BORDER    4
	// Scrollbar width
	#define KVI_IRC_VIEW_SCROLLBAR_WIDTH   16
	// If you have changed the two above, please recalculate this one
	#define KVI_IRC_VIEW_SCROLLBAR_AND_HORIZONTAL_BORDER_WIDTH 20
	//
	// A little bit more than the scrollbar...
	// Qt+X have strange interactions that I cannot understand when I try to move the splitter
	// to the maximum on the left, Maybe the cache pixmap size becomes negative? (I do not think so)
	// Anyway, when the scroll bar position becomes negative (or the IrcView has smaller width than
	// the scroll bar) X aborts with a funny
	// X Error: BadDrawable (invalid Pixmap or Window parameter) 9
	//   Major opcode:  55
	// Program received signal SIGABRT, Aborted.
	// Do not change unless you are sure that it will not happen :)
	#define KVI_IRC_VIEW_MINIMUM_WIDTH                            20
	#define KVI_IRC_VIEW_PIXMAP_SIZE                              16
	#define KVI_IRC_VIEW_PIXMAP_AND_SEPARATOR                     20
	#define KVI_IRC_VIEW_PIXMAP_SEPARATOR_AND_DOUBLEBORDER_WIDTH  28 // 16+4+(2*4) * Do not change
	#define KVI_IRC_VIEW_SELECT_REPAINT_INTERVAL                 100
#endif

// ===========================================================================
// Input stuff * Ask yourself what you are doing while changing it.
// ===========================================================================

#ifdef _KVI_INPUT_CPP_
	// Default maximum buffer size.
	#define KVI_INPUT_MAX_BUFFER_SIZE 400
	// Border, better do not touch this
	#define KVI_INPUT_BORDER            4
	// Cursor blink time. Just do not set it to a value less than 100 if
	// you do not want to be lagged by your cursors :)
	#define KVI_INPUT_BLINK_TIME      800
	// Drag scroll speed (smaller values = faster)...
	#define KVI_INPUT_DRAG_TIMEOUT     80
	// Maximum entries in the history buffer
	#define KVI_INPUT_HISTORY_ENTRIES  24
#endif

// ===========================================================================
// Taskbar * Ask yourself what you are doing while changing it.
// ===========================================================================

#if defined(_KVI_TASKBAR_CPP_) || defined(_KVI_TASKBARBUTTON_CPP_)
	#define KVI_TASKBAR_BORDER                 2
	#define KVI_TASKBAR_BUTTON_DOUBLE_BORDER   4
	#define KVI_TASKBAR_MINIMUM_WIDTH        100
#endif

// ===========================================================================
// MDI stuff * Ask yourself what you are doing while changing it.
// ===========================================================================

#if defined(_KVI_MDI_CHILD_CPP_) || defined(_KVI_MDI_MANAGER_CPP_) || defined(_KVI_MDI_CAPTION_CPP_)
	#define KVI_MDI_CHILD_SEPARATOR                      2
	// Side border
	#define KVI_MDI_CHILD_BORDER                         3
	// This should be KVI_MDI_CHILD_BORDER * 2
	#define KVI_MDI_CHILD_DOUBLE_BORDER                  6
	// Minimum visible edge of a window in the main window view
	#define KVI_MDI_CHILD_MIN_VISIBLE_EDGE              10
	// Minimum size of the child windows
	#define KVI_MDI_CHILD_MIN_WIDTH                    100
	#define KVI_MDI_CHILD_MIN_HEIGHT                    80
	#define KVI_MDI_CHILD_MOVE_RESISTENCE                4
	#define KVI_MDI_CHILD_MAXIMIZED_HIDDEN_EDGE          3
	#define KVI_MDI_CHILD_DOUBLE_MAXIMIZED_HIDDEN_EDGE   6
#endif

// ===========================================================================
// Output images. Do not change!
// Make sure this stays in sync with kvi_dlgoptions.cpp
// ===========================================================================
#define KVI_OUT_NONE             0
#define KVI_OUT_INTERNAL         1
#define KVI_OUT_ERROR            2
#define KVI_OUT_KVIRC            3
#define KVI_OUT_ECHO             4
#define KVI_OUT_SOCKET           5
#define KVI_OUT_INFO             6
#define KVI_OUT_UNHANDLED        7
#define KVI_OUT_MOTD             8
#define KVI_OUT_UNHANDLED_ERROR  9
#define KVI_OUT_NICKNAME_ERROR  10
#define KVI_OUT_PING            11
#define KVI_OUT_JOIN            12
#define KVI_OUT_TOPIC           13
#define KVI_OUT_TIME            14
#define KVI_OUT_DESYNC          15
#define KVI_OUT_NAMES           16
#define KVI_OUT_PART            17
#define KVI_OUT_KICK            18
#define KVI_OUT_QUIT            19
#define KVI_OUT_QUITSPLIT       20
#define KVI_OUT_SPLIT           21
#define KVI_OUT_UMODE           22
#define KVI_OUT_OP              23
#define KVI_OUT_DEOP            24
#define KVI_OUT_VOICE           25
#define KVI_OUT_DEVOICE         26
#define KVI_OUT_BAN             27
#define KVI_OUT_UNBAN           28
#define KVI_OUT_EXCEPT          29
#define KVI_OUT_UNEXCEPT        30
#define KVI_OUT_KEY             31
#define KVI_OUT_LIMIT           32
#define KVI_OUT_CHANMODE        33
#define KVI_OUT_WHO             34
#define KVI_OUT_PRIVMSG         35
#define KVI_OUT_CTCPREQUEST     36
#define KVI_OUT_CTCPREPLY       37
#define KVI_OUT_CTCPERROR       38
#define KVI_OUT_RAW             39
#define KVI_OUT_OWN             40
#define KVI_OUT_ANTISPAM        41
#define KVI_OUT_NICK            42
#define KVI_OUT_FLOOD           43
#define KVI_OUT_ACTION          44
#define KVI_OUT_NOTICE          45
#define KVI_OUT_DNS             46
#define KVI_OUT_WATCH           47
#define KVI_OUT_HIGHLIGHT       48
#define KVI_OUT_INVITE          49
#define KVI_OUT_DCCINFO         50
#define KVI_OUT_DCCWARNING      51
#define KVI_OUT_DCCERROR        52
#define KVI_OUT_HELP            53
#define KVI_OUT_STDIN           54
#define KVI_OUT_STDOUT          55
#define KVI_OUT_STDERR          56
#define KVI_OUT_DIR             57
#define KVI_OUT_FILE            58
#define KVI_OUT_PLUGIN          59
#define KVI_OUT_HAPPY           60
#define KVI_OUT_UNHAPPY         61
#define KVI_OUT_ANGRY           62
#define KVI_OUT_KILL            63
#define KVI_OUT_KILLED          64
#define KVI_OUT_MULTIMEDIA      65
#define KVI_OUT_WALLOPS         66
#define KVI_OUT_LOG             67
#define KVI_OUT_IDEA            68
#define KVI_OUT_INPUT           69
#define KVI_OUT_PACKET          70
#define KVI_OUT_TALK            71
#define KVI_OUT_SCRIPT          72
#define KVI_OUT_COLORS          73
#define KVI_OUT_ONOTICE         74
#define KVI_OUT_MIRC            75
#define KVI_OUT_WIDGET          76
#define KVI_OUT_SERVERROR       77
#define KVI_OUT_WND_CONSOLE     78
#define KVI_OUT_WND_CHANNEL     79
#define KVI_OUT_WND_QUERY       80
#define KVI_OUT_WND_CHAT        81
#define KVI_OUT_WND_SEND        82
#define KVI_OUT_WND_HELPWINDOW  83
#define KVI_OUT_WND_DIRBROWSER  84
#define KVI_OUT_WND_VOICE       85
#define KVI_OUT_WND_LINKS       86
#define KVI_OUT_WND_LIST        87
#define KVI_OUT_WND_UWINDOW     88
#define KVI_OUT_HALFOP          89
#define KVI_OUT_DEHALFOP        90
#define KVI_OUT_USEROP          91
#define KVI_OUT_DEUSEROP        92
#define KVI_OUT_OWNER           93
#define KVI_OUT_DEOWNER         94
#define KVI_OUT_NUM_IMAGES      95

// ===========================================================================
// Output image library files * Do not change
// ===========================================================================

#define KVI_LISTBOX_IMAGE_LIBRARY_NAME       "kvi_listbox.png"
#define KVI_OUT_ICONS_IMAGE_LIBRARY_NAME     "kvi_out_icons.png"
#define KVI_SPLASH_IMAGE_NAME                "splash.png"

// ===========================================================================
// Browser
// ===========================================================================
#define KVI_DIRBROWSER_MAX_BOOKMARKS 15

// ===========================================================================
// Options widget
// ===========================================================================
#define KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER   4
#define KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE    2

// ===========================================================================
// Magic string for the KVIrc config files * Do not change
// ===========================================================================
#define KVI_MAGIC_STRING "KVirc binary configuration file\nPlease do not edit!\n"
#define KVI_MAGIC_STRING_LENGTH       52

#define KVI_MAGIC_THEME_STRING "KVirc theme file\nPlease do not edit\n"
#define KVI_MAGIC_THEME_STRING_LENGTH 36

#define KVI_HELP_QML_MAIN_TOPIC_FILE "index.kvihelp"

// Timeout for the KviWhatIsThis selection of the widget (in msecs)
#define KVI_WHATISTHIS_SELECTION_TIMEOUT 5000

// Timeout for text in the KviStatusBar
#define KVI_TEMP_TEXT_TIMEOUT            5000

// Maximum number of window property entries
#define KVI_MAX_SAVED_WINDOW_PROPERTIES    30

// Maximum size of an outgoing packet
#define KVI_DCC_SEND_MAX_BLOCK_SIZE      4096

// Tab width
#define KVI_TAB_WIDTH 4

// Maximum number in recent menu entries
#define KVI_MAX_RECENT_ENTRIES        10

#define KVI_RECONNECT_TIMEOUT_IN_SECS  5

#define KVI_APP_STYLE_MOTIF            0
#define KVI_APP_STYLE_CDE              1
#define KVI_APP_STYLE_INTERLACE        2
#define KVI_APP_STYLE_MOTIF_PLUS       3
#define KVI_APP_STYLE_SGI              4
#define KVI_APP_STYLE_WINDOWS          5
#define KVI_APP_STYLE_PLATINUM         6
#ifdef COMPILE_WITH_KDE
#define KVI_APP_STYLE_KDE_DEFAULT      7
#endif

#ifdef _KVI_CONFIG_CPP_
	#define KVI_CONFIG_DEFAULT_GROUP "KVIrc_Config"
#endif

#define KVI_DEFAULT_FONTSIZE   11
#define KVI_DEFAULT_FONT       "Bitstream Vera Sans"
#define KVI_DEFAULT_FIXED_FONT "Bitstream Vera Sans Mono"

#endif // _KVI_DEFINES_H_INCLUDED_
