#ifndef _KVI_SPLASHSCREEN_H_INCLUDED_
#define _KVI_SPLASHSCREEN_H_INCLUDED_

// =============================================================================
//
//      --- kvi_splashscreen.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>

class QPixmap;

class KviLabel;
class KviProgress;

class KviSplashScreen : public QFrame
{
	Q_OBJECT
public:
	KviSplashScreen(const QPixmap &pix);
	KviSplashScreen();
	~KviSplashScreen();
private:
	KviProgress *m_pProgress;
	KviLabel    *m_pLabel;
	KviLabel    *m_pPixLabel;
private:
	void init(const QPixmap &pix);
public:
	void setProgress(int progress);
	void setText(const char *text);
protected:
	virtual void showEvent(QShowEvent *);
};

#endif // _KVI_SPLASHSCREEN_H_INCLUDED_
