#ifndef _KVI_PROCESSCONTROLLER_QT_H_INCLUDED_
#define _KVI_PROCESSCONTROLLER_QT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_processcontroller_qt.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qobject.h>
#include <qptrlist.h>

class QSocketNotifier;

class KviProcess;

/**
 *  Simple versions of the KProcess and KProcessController classes
 *  original code by (C) Christian Czezatke
 *  e9025461@student.tuwien.ac.at
 *  Really good work :)
 */
class KviProcessController : public QObject
{
	Q_OBJECT
	friend class KviProcess;
protected:
	KviProcessController();
public:
	~KviProcessController();
public:
	int m_fd[2];
private:
	QPtrList<KviProcess> *m_pProcessList;
	QSocketNotifier      *m_pNotifier;
protected:
	void    addProcess(KviProcess *proc);
	void removeProcess(KviProcess *proc);
protected slots:
	void slotDoHousekeeping(int);
};

#endif // _KVI_PROCESSCONTROLLER_QT_H_INCLUDED_
