//LabPlot : GraphGRASS.cc

#include <iostream>
#include <qstringlist.h>
#include <qprogressdialog.h>
#include <kdebug.h>
#include "GraphGRASS.h"

using namespace std;

GraphGRASS::GraphGRASS(QString n, QString l,LRange r[2], LSource src, PType t, Style st,
		Symbol sy, int nr)
	: Graph(n,l,src,t,st,sy,nr)
{
	//TODO : Range ?
	range = new LRange[2];
	if (r) {
		for (int i=0;i<2;i++) {
			range[i].setMin(r[i].rMin());
			range[i].setMax(r[i].rMax());
		}
	}
}

QStringList GraphGRASS::Info() {
	//TODO
	QStringList s;
	QString t="GRASS";

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << name << t << sh;
	s << QString::number(number);
	s << QString(" 1 ");		// only 1 column
	s << QString::number(range[0].rMin()) + " .. " +QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " +QString::number(range[1].rMax());
	
	return s;
}

void GraphGRASS::save(QTextStream *t) {
	*t<<(int) ltype<<endl;
	*t<<layer<<endl;

	saveGraph(t);
	*t<<number<<endl;
       	*t<<range[0].rMin()<<' '<<range[0].rMax()<<' '<<range[1].rMin()<<' '<<range[1].rMax()<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);
}

void GraphGRASS::open(QTextStream *t,int version) {
	if (version > 13) {
		kdDebug()<<"GraphGRASS::open()"<<endl;
		int tmp;
		*t>>tmp;
		ltype = (LType) tmp;
		*t>>layer;

		openGraph(t,version);
		*t>>number;

		kdDebug()<<"GraphGRASS : "<<endl;
		kdDebug()<<"     name : "<<name<<endl;
		kdDebug()<<"     label : "<<label<<endl;
		kdDebug()<<"     number :  "<<number<<endl;

		double xmin, xmax, ymin, ymax;
		*t>>xmin>>xmax>>ymin>>ymax;
		range[0].setMin(xmin);
		range[0].setMax(xmax);
		range[1].setMin(ymin);
		range[1].setMax(ymax);

		kdDebug()<<"GraphGRASS : reading ranges"<<endl;

		type = (PType) style.open(t,version);
		symbol.open(t,version);
	}
}
