/*
 *   LADCCA
 *    
 *   Copyright (C) 2002, 2003 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_SERVER_CLIENT_H__
#define __LADCCA_SERVER_CLIENT_H__

#include <stdint.h>
#include <uuid/uuid.h>

#include <ladcca/ladcca.h>

#define CCA_CONFIGURED_WITH_DATA_SET(x)  ((x) & CCA_Config_Data_Set)
#define CCA_CONFIGURED_WITH_FILE(x)      ((x) & CCA_Config_File)
#define CCA_IS_SERVER_INTERFACEE(x)      ((x) & CCA_Server_Interface) 
#define CCA_NO_AUTORESUME(x)             ((x) & CCA_No_Autoresume)
#define CCA_RUNS_IN_TERMINAL(x)          ((x) & CCA_Terminal)

#define CCA_CLIENT_CONFIGURED_WITH_DATA_SET(x)  ((cca_client_get_flags (x)) & CCA_Config_Data_Set)
#define CCA_CLIENT_CONFIGURED_WITH_FILE(x)      ((cca_client_get_flags (x)) & CCA_Config_File)
#define CCA_CLIENT_IS_SERVER_INTERFACE(x)       ((cca_client_get_flags (x)) & CCA_Server_Interface)
#define CCA_CLIENT_NO_AUTORESUME(x)             ((cca_client_get_flags (x)) & CCA_No_Autoresume)
#define CCA_CLIENT_RUNS_IN_TERMINAL(x)          ((cca_client_get_flags (x)) & CCA_Terminal)

struct _cca_client {
  char *            project_name;
  
  int               flags;
  int               argc;
  char            **argv;
  char             *working_dir;
  uuid_t            id;
  char             *class;
  
  struct _cca_comm *comm;
  
  /* this is used for the server name and port in the server-side loader */
  char             *server_name;

  /* this is also used for the protocol version in Connect events */
  uint32_t server_connected;
};

void cca_client_init (cca_client_t * client);
void cca_client_free (cca_client_t * client);

cca_client_t * cca_client_new ();
void           cca_client_destroy (cca_client_t *);
cca_client_t * cca_client_dup     (const cca_client_t *);

const char *                 cca_client_get_project_name (const cca_client_t * client);
enum CCA_Client_Flags        cca_client_get_flags (const cca_client_t * client);
const char *                 cca_client_get_working_dir (const cca_client_t * client);
int                          cca_client_get_argc (const cca_client_t * client);
char **                      cca_client_get_argv (const cca_client_t * client);
struct _cca_comm *           cca_client_get_comm (const cca_client_t * client);
const char *                 cca_client_get_server_name (const cca_client_t * client);
void                         cca_client_get_id (const cca_client_t * client, uuid_t id_copy);
const char *                 cca_client_get_id_str (const cca_client_t * client);
const char *                 cca_client_get_class (const cca_client_t * client);
uint32_t                     cca_client_get_server_connected (const cca_client_t * client);

void cca_client_set_project_name (cca_client_t * client, const char * project);
void cca_client_set_flags (cca_client_t * client, enum CCA_Client_Flags);
void cca_client_set_working_dir (cca_client_t * client, const char * working_dir);
void cca_client_set_args (cca_client_t * client, int argc, char ** argv);
void cca_client_set_comm (cca_client_t * client, struct _cca_comm * comm);
void cca_client_set_server_name (cca_client_t * client, const char * name);
void cca_client_set_id (cca_client_t * client, uuid_t id);
void cca_client_set_class (cca_client_t * client, const char * class);
void cca_client_set_server_connected (cca_client_t * client, uint32_t connected);

#endif /* __LADCCA_SERVER_CLIENT_H__ */
