/* -*-C-*-

$Id: if-params.c,v 1.2 2003/01/20 20:48:30 cph Exp $

Copyright 2002 Massachusetts Institute of Technology

This file is part of laptop-net.

Laptop-net is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Laptop-net is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with laptop-net; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "if-params.h"

#define READ_ADDR(symbol, field, addr_flag)				\
{									\
  strncpy ((ifr . ifr_name), name, IF_NAMESIZE);			\
  if ((ioctl (fd, symbol, (&ifr))) < 0)					\
    {									\
      if (errno != EADDRNOTAVAIL)					\
	{								\
	  perror (#symbol);						\
	  goto done;							\
	}								\
      (ifp -> addr_flags) &=~ (addr_flag);				\
    }									\
  else									\
    {									\
      (ifp -> field)							\
	= (* ((struct sockaddr_in *) (& (ifr . ifr_##field))));		\
      (ifp -> addr_flags) |= (addr_flag);				\
    }									\
}

int
read_interface_configuration (const char * name, struct if_params * ifp)
{
  int fd;
  struct ifreq ifr;
  int result = (-1);

  if ((strlen (name)) > IF_NAMESIZE)
    {
      fprintf (stderr, "Illegal network interface name '%s'.\n", name);
      return (-1);
    }
  fd = (socket (AF_INET, SOCK_DGRAM, 0));
  if (fd < 0)
    {
      perror ("socket");
      goto done;
    }

  strncpy ((ifr . ifr_name), name, IF_NAMESIZE);
  if ((ioctl (fd, SIOCGIFFLAGS, (&ifr))) < 0)
    {
      perror ("SIOCGIFFLAGS");
      goto done;
    }
  (ifp -> flags) = (ifr . ifr_flags);

  (ifp -> addr_flags) = 0;
  READ_ADDR (SIOCGIFADDR, addr, IFP_VALID_ADDR);
  READ_ADDR (SIOCGIFDSTADDR, dstaddr, IFP_VALID_DSTADDR);
  READ_ADDR (SIOCGIFBRDADDR, broadaddr, IFP_VALID_BROADADDR);
  READ_ADDR (SIOCGIFNETMASK, netmask, IFP_VALID_NETMASK);

  result = 0;
 done:
  close (fd);
  return (result);
}

#define WRITE_FIELD(symbol)						\
{									\
  strncpy ((ifr . ifr_name), name, IF_NAMESIZE);			\
  if ((ioctl (fd, symbol, (&ifr))) < 0)					\
    {									\
      perror (#symbol);							\
      goto done;							\
    }									\
}

#define WRITE_ADDR(symbol, field, addr_flag)				\
{									\
  if (((ifp -> addr_flags) & (addr_flag)) != 0)				\
    {									\
      (* ((struct sockaddr_in *) (& (ifr . ifr_##field))))		\
	= (ifp -> field);						\
      WRITE_FIELD (symbol);						\
    }									\
}

int
write_interface_configuration (const char * name, struct if_params * ifp)
{
  int fd;
  struct ifreq ifr;
  int result = (-1);

  if ((strlen (name)) > IF_NAMESIZE)
    {
      fprintf (stderr, "Illegal network interface name '%s'.\n", name);
      return (-1);
    }
  fd = (socket (AF_INET, SOCK_DGRAM, 0));
  if (fd < 0)
    {
      perror ("socket");
      goto done;
    }

  WRITE_ADDR (SIOCSIFADDR, addr, IFP_VALID_ADDR);
  WRITE_ADDR (SIOCSIFDSTADDR, dstaddr, IFP_VALID_DSTADDR);
  WRITE_ADDR (SIOCSIFBRDADDR, broadaddr, IFP_VALID_BROADADDR);
  WRITE_ADDR (SIOCSIFNETMASK, netmask, IFP_VALID_NETMASK);

  (ifr . ifr_flags) = (ifp -> flags);
  WRITE_FIELD (SIOCSIFFLAGS);

  result = 0;
 done:
  close (fd);
  return (result);
}
