/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "PTTPreferences.h"

const int BORDER_SIZE = 5;

enum {
	Button_PTT_None = 200,
	Button_PTT_Serial
};

BEGIN_EVENT_TABLE(CPTTPreferences, wxPanel)
	EVT_RADIOBUTTON(Button_PTT_None, CPTTPreferences::onType)
	EVT_RADIOBUTTON(Button_PTT_Serial, CPTTPreferences::onType)
END_EVENT_TABLE()

CPTTPreferences::CPTTPreferences(wxWindow* parent, int id, const wxString& type, const wxString& device) :
wxPanel(parent, id),
m_device(NULL),
m_type(type)
{
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	wxBoxSizer* deviceSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* label = new wxStaticText(this, -1, wxT("Device"));
	deviceSizer->Add(label, 0, wxALL | wxALIGN_CENTRE_VERTICAL | wxALIGN_RIGHT, BORDER_SIZE);

	m_device = new wxTextCtrl(this, -1, device);
	deviceSizer->Add(m_device, 0, wxALL | wxALIGN_CENTRE_VERTICAL | wxALIGN_LEFT, BORDER_SIZE);

	sizer->Add(deviceSizer, 0, wxALL, BORDER_SIZE);

	wxStaticBoxSizer* typeBox = new wxStaticBoxSizer(new wxStaticBox(this, -1, wxT("Type")), wxVERTICAL);

	wxRadioButton* none = new wxRadioButton(this, Button_PTT_None, wxT("None"));
	if (m_type.IsSameAs(wxT("none"), false)) none->SetValue(true);
	typeBox->Add(none, 0, wxALL, BORDER_SIZE);

	wxRadioButton* serial = new wxRadioButton(this, Button_PTT_Serial, wxT("Serial"));
	if (m_type.IsSameAs(wxT("serial"), false)) serial->SetValue(true);
	typeBox->Add(serial, 0, wxALL, BORDER_SIZE);

	sizer->Add(typeBox, 0, wxALL, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CPTTPreferences::~CPTTPreferences()
{
}

void CPTTPreferences::onType(const wxCommandEvent& event)
{
	switch (event.GetId()) {
		case Button_PTT_None:
			m_type = wxT("none");
			m_device->SetValue(wxT("/dev/null"));
			break;
		case Button_PTT_Serial:
			m_type = wxT("serial");
			m_device->SetValue(wxT("/dev/ttyS0"));
			break;
	}
}

bool CPTTPreferences::isValid() const
{
	return !m_device->GetValue().IsEmpty();
}

wxString CPTTPreferences::getType() const
{
	return m_type;
}

wxString CPTTPreferences::getDevice() const
{
	return m_device->GetValue();
}
