/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441FileReceive.h"
#include "FSK441Defs.h"

#include "fsk441gui/FSK441App.h"

#include <wx/debug.h>
#include <wx/log.h>

CFSK441FileReceive::CFSK441FileReceive() :
CFSK441Receive(),
m_fileName(wxEmptyString),
m_soundDev(NULL)
{
}

CFSK441FileReceive::~CFSK441FileReceive()
{
}

bool CFSK441FileReceive::getEndTime()
{
	return false;
}

void CFSK441FileReceive::setFileName(const wxString& fileName)
{
	wxASSERT(m_soundDev == NULL);

	m_fileName = fileName;

	m_soundDev = CSoundDev::createSoundDev(wxT("file"), fileName, FSK441_SAMPLE_RATE, 16);
	m_soundDev->openRead();
}

void CFSK441FileReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);
}

void CFSK441FileReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
	delete m_soundDev;

	m_soundDev = NULL;
}

void CFSK441FileReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);
}

void CFSK441FileReceive::receiveMessage(CFSK441Message* message) const
{
	::wxGetApp().receiveFileMessage(message);
}

void CFSK441FileReceive::showLevels(CFSK441Levels* levels) const
{
	::wxGetApp().showFileLevels(levels);
}

void CFSK441FileReceive::showSpectrum(CFSK441Spectrum* spectrum) const
{
	::wxGetApp().showFileSpectrum(spectrum);
}

wxString CFSK441FileReceive::createId()
{
	wxString id = m_fileName;

	int pos = id.Find(wxT('/'), true);
	if (pos != -1) {
		wxString temp = id.Mid(pos + 1);
		id = temp;
	}

	pos = id.Find(wxT('.'));
	if (pos != -1) {
		wxString temp = id.Mid(0, pos);
		id = temp;
	}

	return id;
}

void CFSK441FileReceive::error(const wxString& text)
{
        ::wxLogError(wxT("%ld: %s"), GetId(), text.c_str());

	::wxGetApp().error(text);
}
