/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef JT44Receive_H
#define	JT44Receive_H

#include <wx/thread.h>

#include "JT44Levels.h"
#include "JT44Message.h"

#include "common/Receive.h"
#include "common/SoundDev.h"
#include "common/Correlation.h"
#include "common/Average.h"

class CJT44Receive : public CReceive {

    public:
	CJT44Receive();
	virtual ~CJT44Receive();

	virtual void run();

	virtual void       openSoundDevice() = 0;
	virtual CSoundDev* getSoundDevice() = 0;
	virtual void       closeSoundDevice() = 0;

	virtual bool getEndTime() = 0;

	virtual void recordAudio(const wxString& id, double* audioData, int length) const = 0;
	virtual void showLevels(CJT44Levels* levels) const = 0;
	virtual void receiveMessage(CJT44Message* message) const = 0;

	virtual wxString createId()  = 0;

    private:
	double*       m_audioSamples;
	CCorrelation* m_correlations;
	int           m_samplesCount;
	CAverage      m_level;

	void storeCorrelations(double* bins, int samplesCount);
	void createReceiveData() const;
	void findCorrelation(int& syncBin, int& timeOffset) const;
	void correlate(int syncBin, int& timeOffset) const;
	void decode(const wxString& id, int syncBin, int timeOffset) const;

	int  getCorrelationsIndex(int bin, int timeOffset) const;
	int  getSymbolsIndex(int letter, int pos) const;

	double calculateTime(int timeOffset) const;
	int    calculateFrequency(int bin) const;
};

#endif
