package tests::ChartTypesDistTest;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::ChartTypes::Dist;
use Lire::Config::Build qw/ac_info/;
use Lire::Config::ChartSpec;
use Lire::Config::ExecutableSpec;
use Lire::PluginManager;
use Lire::ReportParser::ReportBuilder;
use Lire::Utils qw/tempdir/;

use File::Basename qw/dirname/;
use IO::Scalar;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'cfg'}{'ploticus_path'} = 
      new Lire::Config::ExecutableSpec( 'name' => 'ploticus_path' )->instance( 'value' => ac_info( 'PLOTICUS' ) );
    $self->{'cfg'}{'lr_chart_font'} = '';
    $self->{'chart_cfg'} = new Lire::Config::ChartSpec( 'name' => 'chart' )->instance();

    return;
}

sub create_plugin {
    return new Lire::ChartTypes::Dist();
}

sub properties_spec_file {
    return dirname( __FILE__ ) . "/../Lire/ChartTypes/ct_dist.xml";
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/ChartTypes/ct_dist_init";
}

sub set_up_subreport {
    my $self = $_[0];

    my $parser = new Lire::ReportParser::ReportBuilder();
    my $report = $parser->parsefile( dirname( __FILE__ ) . "/data/test-sqlite.xml" );
    $self->{'subreport'} = $report->subreport_by_id( 'top-files.0' );
}

sub test_write_parameters {
    my $self = $_[0];

    $self->set_up_subreport();

    $self->test_registration_file();
    $self->{'chart_cfg'}->get( 'type' )->set_plugin( 'dist' );

    my $dist = Lire::PluginManager->get_plugin( 'chart_type', 'dist' );
    my $fh = new IO::Scalar;
    my $buf = $fh->sref();

    $self->{'subreport'}->table_info()->set_variables_indices();
    $self->{'chart_cfg'}->type_properties()->get( 'x' )->set( 'request_total' );

    $dist->write_parameters( $self->{'chart_cfg'}, $fh );
    $self->assert_matches( qr/#set x = 2\n#set curve = yes/, $$buf );

    $$buf = '';
    $self->{'chart_cfg'}->type_properties()->get( 'curve' )->set( 0 );
    $dist->write_parameters( $self->{'chart_cfg'}, $fh );
    $self->assert_matches( qr/#set x = 2\n#set curve = no/, $$buf );
}

sub test_write_chart {
    my $self = $_[0];

    my $keep = $ENV{'KEEP_CHART'} || 0;
    my $parser = new Lire::ReportParser::ReportBuilder();
    my $report = $parser->parsefile( dirname( __FILE__ ) . "/data/test-sqlite.xml" );

    my $subreport = $report->subreport_by_id( 'top-files.0' );
    $self->test_registration_file();
    $self->{'chart_cfg'}->get( 'name' )->set( 'dist' );
    $self->{'chart_cfg'}->get( 'type' )->set_plugin( 'dist' );
    my $dist = Lire::PluginManager->get_plugin( 'chart_type', 'dist' );

    $self->{'chart_cfg'}->get( 'case_var' )->set( 'file' );
    $self->{'chart_cfg'}->get( 'type' )->get_properties()->get( 'x' )->set( 'request_total' );

    my $dir = tempdir( $self->name() . '_XXXXXX', CLEANUP => !$keep );
    my $chart = $dist->write_chart( $self->{'chart_cfg'}, $subreport,
                                   'outputdir' => $dir, 'format' => 'png', );
    $self->assert( -f $chart ? 1 : 0, "file '$chart' not created" );
    warn( "\nChart written in: $chart\n"  )
      if $keep;
}


1;
