/*
 * $Id: services.h,v 1.8 2001/03/20 14:42:11 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 *  services.h  --  All the services the LysKOM server makes available
 *		    for clients.
 *
 *  Requires kom-types.h
 *
 *  Created by ceder 1990-03-23
 */


#ifndef  _SERVICES_H_ALREADY_INCLUDED__
#define  _SERVICES_H_ALREADY_INCLUDED__


#	define	KOM_(function)		kom_ ## function
#	define	CONST			const


/*
 * Session control
 */
extern  Success
KOM_( open_connection (const char	* server, int portno));

extern  void
KOM_( set_storage_management (malloc_function	new_malloc,
			      realloc_function	new_realloc,
			      free_function	new_free));



extern  Success
KOM_( login (Pers_no		person,
	     const String	passwd,
	     Bool		invisible));

extern  Success
KOM_( logout (void));	/* can never fail */

/* Change Conference */
extern  Success
KOM_( change_conference (Conf_no conference));


/* Change name of a person or conference. */
extern  Success
KOM_( change_name (Conf_no	  conf_no,
		   const String	  new_name));

extern  Success
KOM_( change_what_i_am_doing (CONST String  what_am_i_doing ));

/* Client version: one call to set, two to retrieve. */
extern  Success
KOM_( set_client_version (const String client_name,
			  const String client_version));

extern  Success
KOM_( get_client_name (Session_no session_no,
		       String *result));

extern  Success
KOM_( get_client_version (Session_no session_no,
			  String *result));

/* Get info about a session */

extern  Success
KOM_( get_static_session_info (Session_no session_no,
			       Static_session_info *result) );

/*
 * Disconnect a session. You can disconnect your own session (even if
 * you are not logged in) and any session where you are supervisor of
 * the user that is logged in on that session.
 */
extern  Success
KOM_( disconnect (Session_no session_no));

/*
 * Returns your session number
 */
extern  Success
KOM_( who_am_i (Session_no *session_no));

/*
 * Set state in the session
 */

extern  Success
KOM_( user_active (void));

/******************************
*     Person-related calls    *
******************************/

/*
 *  Create a new person.  Returns 0 if any error occured.
 */
extern  Pers_no
KOM_( create_person (const String  name,
		     const String  passwd ));


extern  Success
KOM_( get_person_stat (Pers_no		  person,
		       Person		* result ));



extern  Success
KOM_( get_created_texts (Pers_no	  person,
			 Local_text_no	  first,
			 unsigned long	  no_of_texts,
			 Text_list	* created_texts ));

extern  Success
KOM_( get_membership (Pers_no		  person,
		      unsigned short	  first,
		      unsigned short	  no_of_confs,
		      Bool		  want_read_texts,
		      Membership_list	* memberships ));



extern  Success
KOM_( set_priv_bits (Pers_no	person,
		     Priv_bits	privileges ));


/*  Set the password of PERSON to NEW_PWD.  OLD_PWD is the password
 *  of the person who does the set.  This is not necessarily the
 *  same as the one who gets it set.	*/
extern  Success
KOM_( set_passwd (Pers_no	 person,
		  const String   old_pwd,
		  const String   new_pwd ));


/* You can query for unread texts without logging in. */
extern  Success
KOM_( query_read_texts (Pers_no	     pers_no,
			Conf_no	     conf_no,
			Membership * result   ));


extern Success
KOM_( get_unread_confs(Pers_no       pers_no,
		       Conf_no_list *result));

extern Success
KOM_( set_user_area(Pers_no	pers_no,
		    Text_no	user_area));


/****************************************
*	Conference-related calls	*
****************************************/


extern  Conf_no
KOM_( create_conf (const String	  name,
		   Conf_type	  type ));


/*  Delete a conference.  Also used to delete persons.  */
extern  Success
KOM_( delete_conf (Conf_no	conf ));


/*
 *  Map conference name to number.  Returns a list of the conferences
 *  that match the name NAME. Can be done without logging in.
 */
extern Success
KOM_( lookup_z_name (const String name,
		     int want_persons,
		     int want_confs,
		     Conf_z_info_list *result));

extern  Success
KOM_( re_z_lookup (const String  regexp,
		   int want_persons,
		   int want_confs,
		   Conf_z_info_list *result));

extern  Success
KOM_( get_conf_stat (Conf_no		  conf_no,
		     Conference		* result ));

extern Success
KOM_( get_uconf_stat (Conf_no		  conf_no,
		      Small_conf	* result));

extern  Success
KOM_( get_members (Conf_no	  conf,
		   unsigned short first,
		   unsigned short no_of_members,
		   Member_list	* members	));



/* add_member is also used to change the priority of a conference */
extern  Success
KOM_( add_member (Conf_no		conf_no,
		  Pers_no		pers_no,
		  unsigned char		priority,
		  unsigned short	where	)); /* Range of where is [0..] */


extern  Success
KOM_( sub_member (Conf_no	conf_no,
		  Pers_no	pers_no ));


/*
 * Tell the server that I want to mark/unmark texts as read so that I
 * get no_of_unread unread texts in conf_no.
 *
 * The new alternative function marks last_read as the last read local
 * text. Use this one to avoid race conditions.
 */
extern  Success
KOM_( set_unread (Conf_no   conf_no,
		  Text_no   no_of_unread));

extern  Success
KOM_( set_last_read (Conf_no   conf_no,
		     Local_text_no   last_read));


/*
 * set_presentation and set_etc_motd also does some magic with the
 * no_of_marks field in the Text_stat structure of the old and new text.
 */ 

extern  Success
KOM_( set_presentation (Conf_no   conf_no,
			Text_no   text_no )); /* 0 to delete pres. */

extern  Success
KOM_( set_etc_motd (Conf_no	  conf_no,
		    Text_no	  text_no ));


extern  Success
KOM_( set_supervisor (Conf_no	  conf_no,
		      Conf_no	  admin	));

extern  Success
KOM_( set_permitted_submitters (Conf_no	  conf_no,
				Conf_no	  perm_sub ));

extern  Success
KOM_( set_super_conf (Conf_no	  conf_no,
		      Conf_no	  super_conf ));

extern  Success
KOM_( set_conf_type (Conf_no	  conf_no,
		     Conf_type	  type	));
extern  Success
KOM_( set_garb_nice (Conf_no	  conf_no,
		     Garb_nice	  ndays	)); /* number of days */



/********************************
*     Calls to handle marks     *
********************************/


extern  Success
KOM_( get_marks (Mark_list *result ));



/*
 *  Will fail if the user is not allowed to read the text.
 */
/* Using this function, you can set mark_type==0. */
extern  Success
KOM_( mark_text (Text_no	  text,
		 unsigned char	  mark_type ));


/* Remove a mark, reporting an error if you had not marked the text. */
extern  Success
KOM_( unmark_text (Text_no	  text));




/*******************************
*     Calls to handle texts    *
*******************************/


extern  Success
KOM_( get_text (Text_no	 	  text,
		String_size	  start_char,
		String_size	  end_char,
		String		* result));


extern  Success
KOM_( get_text_stat (Text_no    text,
		     Text_stat *result));

extern  Success
KOM_( mark_as_read (Conf_no		    conference,
		    int			    no_of_texts,
		    const Local_text_no	  * text_arr   ));


/* Returns 0 on error */
extern  Text_no
KOM_( create_text (const String		  message,
		   unsigned short	  no_of_misc,
		   CONST Misc_info	* misc	     ));

/* Returns 0 on error. This function is experimental. */
extern  Text_no
KOM_( create_anonymous_text (const String       message,
			     unsigned short	no_of_misc,
			     CONST Misc_info  * misc	     ));

extern Success
KOM_( delete_text( Text_no text_no ));



extern  Success
KOM_( add_recipient (Text_no	  text_no,
		     Conf_no	  conf_no,
		     Info_type	  type	)); /* recpt or cc_recpt */

extern  Success
KOM_( sub_recipient (Text_no	  text_no,
		     Conf_no	  conf_no ));


extern  Success
KOM_( add_comment (Text_no	  comment,
		   Text_no 	  comment_to ));


/*
 *  Make the text COMMENT to not be a comment to text COMMENT_TO
 */
extern  Success
KOM_( sub_comment (Text_no	  comment,
		   Text_no	  comment_to ));

extern Success
KOM_( add_footnote (Text_no	footnote,
		    Text_no 	footnote_to ));

extern Success
KOM_( sub_footnote (Text_no	footnote,
		    Text_no	parent ));

extern  Success
KOM_( get_map (Conf_no		  conf_no,
	       Local_text_no	  first_local_no,
	       unsigned long	  no_of_texts,
	       Text_list	* result));


/*
 *  Ask what the server thinks the time is. This
 *  might differ if on two different machines.
 */
extern  Success
KOM_( get_time (struct tm *clock_resu));


/*
 *  Gets the last text before a given time.
 */

extern  Success
KOM_( get_last_text (struct tm *clock_resu, Text_no *result));

/*
 * Return next/previous existing text-no.
 */

extern  Success
KOM_( find_next_text_no (Text_no start, Text_no *result));

extern  Success
KOM_( find_previous_text_no (Text_no start, Text_no *result));


/*
 * Who is logged on now?
 */
extern  Success
KOM_( who_is_on_dynamic (int want_visible,
			 int want_invisible,
			 long active_last,
			 Dynamic_session_info_list *result) );

/*
 *  Return various information about the server
 */
extern  Success
KOM_( get_info (Info *result ));

extern  Success
KOM_( get_version_info (Version_info *result ));


/*
 * Privileged calls.
 */

extern Success
KOM_( set_info(Info *info));

extern Success
KOM_( set_motd_of_lyskom (Text_no motd));

/*
 * Set ena_level. 0 means don't use any privileges.
 */
extern Success
KOM_( enable (unsigned char ena_level));

/*
 * Make LysKOM sync its files.
 */
extern Success
KOM_( sync (void) );

/*
 * Close LysKOM.
 */
extern Success
KOM_( shutdown (int exit_val) );

/*
 * Send a message to a person, or all persons. If recipient == 0 all
 * connections will receive the message.
 */
extern Success
KOM_( send_message (Conf_no recipient,
		    const String message) );

/*
 * Selection of asynchronous messages
 */

extern Success
KOM_( accept_async(Number_list *accept_list));

extern Success
KOM_( query_async(Number_list *result));

/*
 * Asynchronous messages.
 */
void
register_new_text(void (*async_new_text)(Text_no    text_no, 
					 Text_stat  text_s));

void
register_i_am_on(void (*async_i_am_on)(Who_info info));

void
register_i_am_off (void (*async_i_am_off)(Pers_no pers_no));

void
register_new_name(void (*async_new_name)(Conf_no  conf_no,
					 String   old_name,
					 String   new_name));
void
register_directed_message(void (*async_message)(Conf_no	to,
						Conf_no	from,
						String	message));

void
register_saving(void (*saving_fun)(void));

    
#endif	/*  _SERVICES_H_ALREADY_INCLUDED__  */
