/*
 *  copy.h
 *	Functions to copy and free the data structures used by LysKOM.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 */


#ifndef  COPY_H_ALREADY_INCLUDED__
#define  COPY_H_ALREADY_INCLUDED__

#include <s-string.h>
#include <kom-types.h>


#define s_release(Str_ptr)	(zfree ((Str_ptr)->string), (Str_ptr))
#define s_mark(Str_ptr)		(zuse ((Str_ptr)->string), (Str_ptr))

extern Person		* mark_person (Person *pers);
extern Person		* release_person (Person *pers);

extern Conference	* mark_conf (Conference *conf);
extern Conference	* release_conf (Conference *conf);

extern Misc_info	* mark_misc_list (Misc_info *list, int length);
extern Misc_info	* release_misc_list (Misc_info *list, int length);

extern Text_stat	* mark_text_stat (Text_stat *text);
extern Text_stat	* release_text_stat (Text_stat *text);

extern Membership	* mark_membership (Membership *memb);
extern Membership	* release_membership (Membership *memb);

extern Mark_list	* mark_mark_list (Mark_list *marks);
extern Mark_list	* release_mark_list (Mark_list *marks);

extern Conf_no_list	* release_conf_no_list (Conf_no_list *list);

extern Member_list	* mark_member_list (Member_list *membs);
extern Member_list	* release_member_list (Member_list *membs);

extern Text_list	* mark_text_list (Text_list *texts);
extern Text_list	* release_text_list (Text_list *texts);

extern Membership_list	* mark_membership_list (Membership_list *membships);
extern Membership_list	* release_membership_list (Membership_list *membships);

extern Info		* mark_info (Info *info);
extern Info		* release_info (Info *info);

extern Who_info		* release_who_info (Who_info * info);

extern Conf_z_info	* mark_conf_z_info(Conf_z_info * info);
extern Conf_z_info	* release_conf_z_info(Conf_z_info * info);
extern void		  copy_conf_z_info (Conf_z_info *, Conf_z_info *);

extern Conf_z_info_list * mark_conf_z_info_list(Conf_z_info_list * list);
extern Conf_z_info_list * release_conf_z_info_list(Conf_z_info_list * list);

extern Dynamic_session_info *
mark_dynamic_session_info(Dynamic_session_info *);
extern Dynamic_session_info *
release_dynamic_session_info(Dynamic_session_info *);

extern Dynamic_session_info_list *
mark_dynamic_session_info_list(Dynamic_session_info_list *);
extern Dynamic_session_info_list *
release_dynamic_session_info_list(Dynamic_session_info_list *);

extern Static_session_info * mark_static_session_info(Static_session_info *);
extern Static_session_info *
release_static_session_info(Static_session_info *);

#endif  /*  COPY_H_ALREADY_INCLUDED__ */
