/*
 *  error.h  --  routines for handling errors and displaying error
 *		 messages in the client.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */



#include <kom-errno.h>
#include <kom-types.h>


typedef  enum {
	CLIENT_OUT_OF_MEMORY,
	CLIENT_SERVER_ERROR,		/* A service call resulted in either
					 * a fatal or unexpected error. */
	CLIENT_CONNECTION_LOST,		/* Lost connection to server. */
	CLIENT_UNEXPECTED_SERVER_ERROR,	/* This shouldn't happen! */
	CLIENT_SITUATION_NOT_HANDLED,	/* More thinking to do... */
	CLIENT_SHOULDNT_HAPPEN,		/* Means internal error */
	CLIENT_ERROR_TOO_boring		/* Yes, it is! */
}  Fatal_client_error;



typedef  enum  {
	ambigous_or_no_conf,
	membership_status_changed
}  Type_of_error;


/*
 *  Inform the user about some error condition.
 *  BUG: This function is probably under-used...
 */
extern  void
inform_user (Type_of_error	  condition,
	     Conf_z_info_list	* confs);



/*
 * kom_error_string
 * Returns an error message describing the error ERROR_NO.
 */
extern const char *
kom_error_string(Kom_err  error_no);

/*
 * kom_errno_string
 * conveniance call where we need not give kom_errno as argument.
 */
static inline const char *
kom_errno_string(void)
{
    return kom_error_string(kom_errno);
}


/*  Just some more info to fatal_client_error()  */
typedef	long	fatal_info;

/*
 *  Prints out some appropriate error message and aborts
 *  execution of program.  Some of these things should never
 *  happen, and inicates a bug in either the client or the
 *  server.
 *  When an internal error occurs, 'fatal_client_error' should
 *  be called with FUNCTION_NAME set to the name of the function
 *  where the error occured, DESCRIPTION should be a short
 *  description of the situation in which the error occured, and
 *  EXTRA_INFO should be set to some information useful for
 *  debugging, such as the value of an illegal parameter.
 */
extern  void
fatal_client_error (Fatal_client_error	  error_no,
		    const char		* function_name,
		    const char		* filename,
		    const int		  lineno,
		    const char		* descrfmt, ...)
#ifdef HAVE_GCCSTYLE_ATTRIBUTE_FORMAT
     __attribute__ ((format (printf, 5, 6)))
#endif
;


#define	fatal1(err,extra)	\
    fatal_client_error(err, FUNCTION, __FILE__, __LINE__, extra)
#define	fatal2(err,extra1,extra2)	\
    fatal_client_error(err, FUNCTION, __FILE__, __LINE__, extra1,extra2)
#define	fatal3(err,extra1,extra2,extra3)	\
    fatal_client_error(err, FUNCTION, __FILE__, __LINE__, \
		       extra1,extra2,extra3)
#define	fatal4(err,extra1,extra2,extra3,extra4)	\
    fatal_client_error(err, FUNCTION, __FILE__, __LINE__, \
		       extra1,extra2,extra3,extra4)
#define	fatal5(err,extra1,extra2,extra3,extra4,extra5)	\
    fatal_client_error(err, FUNCTION, __FILE__, __LINE__, \
		       extra1,extra2,extra3,extra4,extra5)

/*  Just some more info to fatal_client_error()  */
typedef	long	bug_info;

/*
 *  Print a message telling the user that a bug in the LysKOM
 *  server has been detected, the symtoms of the bug (BUG_TEXT),
 *  in what function in the client the bug was detected
 *  (FUNCTION) and some more information that might be used for
 *  post-mortem debugging.
 */
extern  void
server_bug (const char	* bug_text,
	    const char	* function,
	    bug_info	  extra_info);
